/* Copyright (C) 2005 Jaap Taal and Marcel Vlastuin.

This file is part of the Caia project. This project can be
downloaded from the website www.codecup.nl. You can email to
marcel@vlastuin.net or write to Marcel Vlastuin, Perenstraat 40,
2564 SE Den Haag, The Netherlands.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; see the file COPYING.  If not, write to
the Free Software Foundation, 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "rolit.h"

// The board is saved in the double char array bord:

char bord[8][8];

int main(int argc, char *argv[])
{
  FILE *log=NULL;

// The number of moves is stored in the (countdown) variable number:
  
  int number=60, move, errorplayer=0, t1, t2, t3, t4, points[4], tt;
  int i, j; 
  char input[100], *endptr;

// If there is a log file available, open it en use it:
  
  if (argc>=2) log=fopen(argv[1], "w");

  if (log)
  {
    fprintf(log, "Game log: %s\n\n", argv[1]);
    fflush(log);
  }
  
// Set the initial board position:
  
  for (i=0; i<8; ++i) for (j=0; j<8; ++j) bord[i][j]=0;
  bord[3][3]=1; bord[3][4]=2; bord[4][3]=4; bord[4][4]=3;
  
// Inform each player who he is:
  
  printf("1 1\n"); fflush(stdout);
  printf("2 2\n"); fflush(stdout);
  printf("3 3\n"); fflush(stdout);
  printf("4 4\n"); fflush(stdout);

// Play one game:
  
  do
  {

// Read the move from player 1:
    
    printf("I lock\n"); fflush(stdout);
    do scanf("%s", input); while (strcmp(input, "lock_ok"));
    printf("I listen 1\n"); fflush(stdout);
    scanf("%s", input);
    move = strtol(input, &endptr, 10); // Convert the input into an integer
    printf("I unlock\n"); fflush(stdout);

// Make a simple (but not complete) check on the move:
    
    if (move<=0 || move>64 || bord[(move-1)/8][(move-1)%8])
    {
      printf("2 0\n"); fflush(stdout); // Stop player 2
      printf("3 0\n"); fflush(stdout); // Stop player 3
      printf("4 0\n"); fflush(stdout); // Stop player 4
      errorplayer=1; // Player 1 made an error and is addressed now
      break;
    }

// Inform the other three players about the move from player 1:
    
    printf("2 %d\n", move); fflush(stdout);
    printf("3 %d\n", move); fflush(stdout);
    printf("4 %d\n", move); fflush(stdout);

// Process the move for the referee (doezet = do_the_move):
    
    doezet(1, (move-1)/8, (move-1)%8);

// If a log file is used, report the move:
    
    if (log)
    {
      fprintf(log, "move %2d: %2d\n", 61-number, move);
      fflush(log);
    }

// Print the board:
    
    printbord();

// Decrease the number of moves to be played:    
    
    --number;
    
// Continue for the moves of the other three players:
    
    printf("I lock\n"); fflush(stdout);
    do scanf("%s", input); while (strcmp(input, "lock_ok"));
    printf("I listen 2\n"); fflush(stdout);
    scanf("%s", input);
    move=strtol(input, &endptr, 10);
    printf("I unlock\n"); fflush(stdout);
    if (move<=0 || move>64 || bord[(move-1)/8][(move-1)%8])
    {
      printf("1 0\n"); fflush(stdout);
      printf("3 0\n"); fflush(stdout);
      printf("4 0\n"); fflush(stdout);
      errorplayer=2;
      break;
    }
    printf("1 %d\n", move); fflush(stdout);
    printf("3 %d\n", move); fflush(stdout);
    printf("4 %d\n", move); fflush(stdout);
    doezet(2, (move-1)/8, (move-1)%8);
    if (log) 
    {
      fprintf(log, "move %2d: %2d\n", 61-number, move);
      fflush(log);
    }
    printbord();
    --number;
    
    printf("I lock\n"); fflush(stdout);
    do scanf("%s", input); while (strcmp(input, "lock_ok"));
    printf("I listen 3\n"); fflush(stdout);
    scanf("%s", input);
    move=strtol(input, &endptr, 10);
    printf("I unlock\n"); fflush(stdout);
    if (move<=0 || move>64 || bord[(move-1)/8][(move-1)%8])
    {
      printf("1 0\n"); fflush(stdout);
      printf("2 0\n"); fflush(stdout);
      printf("4 0\n"); fflush(stdout);
      errorplayer=3;
      break;
    }
    printf("1 %d\n", move); fflush(stdout);
    printf("2 %d\n", move); fflush(stdout);
    printf("4 %d\n", move); fflush(stdout);
    doezet(3, (move-1)/8, (move-1)%8);
    if (log)
    {
      fprintf(log, "move %2d: %2d\n", 61-number, move);
      fflush(log);
    }
    printbord();
    --number;

    printf("I lock\n"); fflush(stdout);
    do scanf("%s", input); while (strcmp(input, "lock_ok"));
    printf("I listen 4\n"); fflush(stdout);
    scanf("%s", input);
    move=strtol(input, &endptr, 10);
    printf("I unlock\n"); fflush(stdout);
    if (move<=0 || move>64 || bord[(move-1)/8][(move-1)%8])
    {
      printf("1 0\n"); fflush(stdout);
      printf("2 0\n"); fflush(stdout);
      printf("3 0\n"); fflush(stdout);
      errorplayer=4;
      break;
    }
    printf("1 %d\n", move); fflush(stdout);
    printf("2 %d\n", move); fflush(stdout);
    printf("3 %d\n", move); fflush(stdout);
    doezet(4, (move-1)/8, (move-1)%8);
    if (log)
    {
      fprintf(log, "move %2d: %2d\n", 61-number, move);
      fflush(log);
    }
    printbord();
  } while (--number);

// If a player made an error, report it:
    
  if (errorplayer)
  {
    fprintf(stderr, "R: an error occurs, player %d (or the caiaio) sends: %s\n", errorplayer, input);
    fflush(stderr);
    if (log) {fprintf(log, "\nAn error occured, player %d (or the caiaio) sent: %s\n", errorplayer, input); fflush(log);}
  }

// Request the playing time of all players from the cacaio for the report:
    
  printf("I lock\n"); fflush(stdout);
  do scanf("%s", input); while (strcmp(input, "lock_ok"));
  printf("I request_time 1\n"); fflush(stdout);
  scanf("%s%d%d", input, &t1, &tt); // In t1 the actual playing time in milliseconds is stored
                                    // The estimated time is ommited in this version of the referee
  printf("I request_time 2\n"); fflush(stdout);
  scanf("%s%d%d", input, &t2, &tt);
  printf("I request_time 3\n"); fflush(stdout);
  scanf("%s%d%d", input, &t3, &tt);
  printf("I request_time 4\n"); fflush(stdout);
  scanf("%s%d%d", input, &t4, &tt);
  printf("I unlock\n"); fflush(stdout);
  
// tel_aantal() is a function that counts the number of pieces of each player on the board:
  
  tel_aantal(points);

// Make the number of points of an errorplayer negative to indicated he made an error:
  
  if (errorplayer) points[errorplayer-1]=-points[errorplayer-1];
  
// Report the manager what happened:
  
  sprintf(input, "M %d %d %d %d %d %d %d %d\n", points[0], points[1], points[2], points[3], t1, t2, t3, t4);
  printf(input); fflush(stdout);

// Write in the log file the result:  
  
  if (log) {fprintf(log, "\nManager report: "); fprintf(log, input); fflush(log);}
  
  return 0;
}
