/* Copyright (C) 2000 Menno Zuidema.
   Copyright (C) 2005 Jaap Taal and Marcel Vlastuin.

The game Rolit was programmed by Menno Zuidema under supervision
of Marcel Vlastuin at the Dalton Den Haag. The player in the game
was adapted to an example player to be used in the Caia project.

This file is part of the Caia project. This project can be
downloaded from the website www.codecup.nl. You can email to
marcel@vlastuin.net or write to Marcel Vlastuin, Perenstraat 40,
2564 SE Den Haag, The Netherlands.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; see the file COPYING.  If not, write to
the Free Software Foundation, 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */

#include "rolit.h"

extern char bord[][8];

int zoekzet(int kleur, int z[][2][LENZET], int *aantal2)
{
  int slaan, x, y, t, s, u, aantal=0;
  *aantal2=0;
  for (x=0; x<8; ++x) for (y=0; y<8; ++y)
  {
    if (bord[x][y]) continue;
    if (x)
    {
      if (y && bord[x-1][y-1]) goto doorgaan;
      if (bord[x-1][y]) goto doorgaan;
      if (y<7 && bord[x-1][y+1]) goto doorgaan;
    }
    if (x<7)
    {
      if (y && bord[x+1][y-1]) goto doorgaan;
      if (bord[x+1][y]) goto doorgaan;
      if (y<7 && bord[x+1][y+1]) goto doorgaan;
    }
    if (y && bord[x][y-1]) goto doorgaan;
    if (y<7 && bord[x][y+1]) goto doorgaan;
    continue;
doorgaan:
    slaan=NEE;
    s=y;
    while (1) //naar links
    {
      if (--s<0) break;
      if (!(u=bord[x][s])) break;
      else if (u==kleur)
      {
        while (y>++s) {slaan=JA; break;}
        break;
      }
    }
    if (slaan)
    {
      z[JA][0][aantal]=x; z[JA][1][aantal++]=y; continue;
    }
    t=x;
    while (1) //naar onderen
    {
      if (++t>7) break;
      if (!(u=bord[t][y])) break;
      else if (u==kleur)
      {
        while (x<--t) {slaan=JA; break;}
        break;
      }
    }
    if (slaan)
    {
      z[JA][0][aantal]=x; z[JA][1][aantal++]=y; continue;
    }
    s=y;
    while (1) //naar rechts
    {
      if (++s>7) break;
      if (!(u=bord[x][s])) break;
      else if (u==kleur)
      {
        while (y<--s) {slaan=JA; break;}
        break;
      }
    }
    if (slaan)
    {
      z[JA][0][aantal]=x; z[JA][1][aantal++]=y; continue;
    }
    t=x;
    while (1) //naar boven
    {
      if (--t<0) break;
      if (!(u=bord[t][y])) break;
      else if (u==kleur)
      {
        while (x>++t) {slaan=JA; break;}
        break;
      }
    }
    if (slaan)
    {
      z[JA][0][aantal]=x; z[JA][1][aantal++]=y; continue;
    }
    t=x;
    s=y;
    while (1) //naar rechts-onder
    {
      if (++t>7) break;
      if (++s>7) break;
      if (!(u=bord[t][s])) break;
      else if (u==kleur)
      {
        while (y<--s) {slaan=JA; break;}
        break;
      }
    }
    if (slaan)
    {
      z[JA][0][aantal]=x; z[JA][1][aantal++]=y; continue;
    }
    t=x;
    s=y;
    while (1) //naar links-onder
    {
      if (--t<0) break;
      if (++s>7) break;
      if (!(u=bord[t][s])) break;
      else if (u==kleur)
      {
        while (y<--s) {slaan=JA; break;}
        break;
      }
    }
    if (slaan)
    {
      z[JA][0][aantal]=x; z[JA][1][aantal++]=y; continue;
    }
    t=x;
    s=y;
    while (1) //naar rechts-boven
    {
      if (++t>7) break;
      if (--s<0) break;
      if (!(u=bord[t][s])) break;
      else if (u==kleur)
      {
        while (y>++s) {slaan=JA; break;}
        break;
      }
    }
    if (slaan)
    {
      z[JA][0][aantal]=x; z[JA][1][aantal++]=y; continue;
    }
    t=x;
    s=y;
    while (1) //naar links-boven
    {
      if (--t<0) break;
      if (--s<0) break;
      if (!(u=bord[t][s])) break;
      else if (u==kleur)
      {
        while (y>++s) {slaan=JA; break;}
        break;
      }
    }
    if (slaan)
    {
      z[JA][0][aantal]=x; z[JA][1][aantal++]=y; continue;
    }
    z[NEE][0][*aantal2]=x;
    z[NEE][1][(*aantal2)++]=y;
  }
  return aantal;
}

