/* Copyright (C) 2000 Menno Zuidema.
   Copyright (C) 2005 Jaap Taal and Marcel Vlastuin.

The game Rolit was programmed by Menno Zuidema under supervision
of Marcel Vlastuin at the Dalton Den Haag. The player in the game
was adapted to an example player to be used in the Caia project.

This file is part of the Caia project. This project can be
downloaded from the website www.codecup.nl. You can email to
marcel@vlastuin.net or write to Marcel Vlastuin, Perenstraat 40,
2564 SE Den Haag, The Netherlands.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; see the file COPYING.  If not, write to
the Free Software Foundation, 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */

#define NIV 2

#include <stdio.h>
#include <stdlib.h>
#include "rolit.h"
#include "time.h"

char bord[8][8];
int aantal_zetten;

int main(void)
{
  int x, y, speler, u;

//  fprintf(stderr, "S rolit_niv_3\n"); fflush(stderr);
  srand(time(NULL));

  for (x=0; x<8; ++x) for (y=0; y<8; ++y) bord[x][y]=0;
  bord[3][3]=R; bord[3][4]=Y; bord[4][3]=B; bord[4][4]=G;
  aantal_zetten=60;

  scanf("%d", & speler);

  switch(speler)
  {
    case 1: do
	    {
	      bereken(1, NIV, &x, &y);
	      doezet(1, x, y);
              --aantal_zetten;
	      printf("%d\n", 8*x+y+1); fflush(stdout);
	      scanf("%d", &u);
	      if (u--) doezet(2, u/8, u%8); else return 0;
	      --aantal_zetten;
	      scanf("%d", &u);
	      if (u--) doezet(3, u/8, u%8); else return 0;
	      --aantal_zetten;
	      scanf("%d", &u);
	      if (u--) doezet(4, u/8, u%8); else return 0;
	    }
	    while(--aantal_zetten);
	    break;
    case 2: do
	    {
	      scanf("%d", &u);
	      if (u--) doezet(1, u/8, u%8); else return 0;
	      --aantal_zetten;
	      bereken(2, NIV, &x, &y);
	      doezet(2, x, y);
              --aantal_zetten;
	      printf("%d\n", 8*x+y+1); fflush(stdout);
	      scanf("%d", &u);
	      if (u--) doezet(3, u/8, u%8); else return 0;
	      --aantal_zetten;
	      scanf("%d", &u);
	      if (u--) doezet(4, u/8, u%8); else return 0;
	    }
	    while(--aantal_zetten);
	    break;
    case 3: do
	    {
	      scanf("%d", &u);
	      if (u--) doezet(1, u/8, u%8); else return 0;
	      --aantal_zetten;
	      scanf("%d", &u);
	      if (u--) doezet(2, u/8, u%8); else return 0;
	      --aantal_zetten;
	      bereken(3, NIV, &x, &y);
	      doezet(3, x, y);
              --aantal_zetten;
	      printf("%d\n", 8*x+y+1); fflush(stdout);
	      scanf("%d", &u);
	      if (u--) doezet(4, u/8, u%8); else return 0;
	    }
	    while(--aantal_zetten);
	    break;
    case 4: do
	    {
	      scanf("%d", &u);
	      if (u--) doezet(1, u/8, u%8); else return 0;
	      --aantal_zetten;
	      scanf("%d", &u);
	      if (u--) doezet(2, u/8, u%8); else return 0;
	      --aantal_zetten;
	      scanf("%d", &u);
	      if (u--) doezet(3, u/8, u%8); else return 0;
	      --aantal_zetten;
	      bereken(4, NIV, &x, &y);
	      doezet(4, x, y);
	      printf("%d\n", 8*x+y+1); fflush(stdout);
	    }
	    while(--aantal_zetten);
	    break;
  }
  return 0;
}
