/* Copyright (C) 2000 Menno Zuidema.
   Copyright (C) 2005 Jaap Taal and Marcel Vlastuin.

The game Rolit was programmed by Menno Zuidema under supervision
of Marcel Vlastuin at the Dalton Den Haag. The player in the game
was adapted to an example player to be used in the Caia project.

This file is part of the Caia project. This project can be
downloaded from the website www.codecup.nl. You can email to
marcel@vlastuin.net or write to Marcel Vlastuin, Perenstraat 40,
2564 SE Den Haag, The Netherlands.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; see the file COPYING.  If not, write to
the Free Software Foundation, 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */

#include <string.h>
#include <math.h>
#include "rolit.h"

extern char bord[][8];

void analyse(int kleur, int niv, float *red, float *yellow,
	    float *green, float *blue)
{
  int d1=0, d2=0, t, x, aantal, aantal2, z[2][2][LENZET];
  float yellow2, blue2, green2, red2;
  char buf[8][8], *p;
  float waarde=0.0, grootste=-3e4;
  if (!niv)
  {
    yellow2=green2=blue2=red2=0;
    p=bord[0];
    for (x=0; x<64; ++x)
    {
      if (x==0 || x==7 || x==56 || x==63) switch(*p)
      {
	case Y: yellow2+=HOEKWAARDE; break;
	case B: blue2+=HOEKWAARDE; break;
	case G: green2+=HOEKWAARDE; break;
	case R: red2+=HOEKWAARDE; break;
        default: break;
      }
      else switch(*p)
      {
	case Y: ++yellow2; break;
	case B: ++blue2; break;
	case G: ++green2; break;
	case R: ++red2; break;
        default: break;
      }
      ++p;
    }
    *yellow=1.73205*yellow2-sqrt(blue2*blue2+red2*red2+green2*green2);
    *green=1.73205*green2-sqrt(blue2*blue2+red2*red2+yellow2*yellow2);
    *blue=1.73205*blue2-sqrt(yellow2*yellow2+red2*red2+green2*green2);
    *red=1.73205*red2-sqrt(blue2*blue2+green2*green2+yellow2*yellow2);
    return;
  }
  aantal=zoekzet(kleur, z, &aantal2);
  if (!aantal)
  {
    for (t=0; t<aantal2; ++t)
    {
      bord[d1=z[NEE][0][t]][d2=z[NEE][1][t]]=kleur;
      analyse(kleur%4+1, niv-1, &red2, &yellow2, &green2, &blue2);
      bord[d1][d2]=0;
      switch(kleur)
      {
	case Y: waarde=yellow2; break;
	case R: waarde=red2; break;
	case B: waarde=blue2; break;
	case G: waarde=green2; break;
      }
      if (waarde>grootste)
      {
	grootste=waarde;
	*yellow=yellow2;
	*blue=blue2;
	*green=green2;
	*red=red2;
      }
    }
  }
  else for (t=0; t<aantal; ++t)
  {
    memcpy(buf, bord, sizeof(buf));
    doezet(kleur, z[JA][0][t], z[JA][1][t]);
    analyse(kleur%4+1, niv-1, &red2, &yellow2, &green2, &blue2);
    memcpy(bord, buf, sizeof(buf));
    switch(kleur)
    {
      case Y: waarde=yellow2; break;
      case R: waarde=red2; break;
      case B: waarde=blue2; break;
      case G: waarde=green2; break;
    }
    if (waarde>grootste)
    {
      grootste=waarde;
      *yellow=yellow2;
      *blue=blue2;
      *green=green2;
      *red=red2;
    }
  }
  return;
}
