/* Copyright (C) 2005 Jaap Taal and Marcel Vlastuin.

This file is part of the Caia project. This project can be
downloaded from the website www.codecup.nl. You can email to
marcel@vlastuin.net or write to Marcel Vlastuin, Perenstraat 40,
2564 SE Den Haag, The Netherlands.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; see the file COPYING.  If not, write to
the Free Software Foundation, 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */

#include <stdio.h>
#include <string.h>
#include <stdarg.h>

#define LOCK(x) printf("I lock\n"); fflush(stdout); do scanf("%s", (x)); while (strcmp((x), "lock_ok"))
#define UNLOCK printf("I unlock\n"); fflush(stdout)

// prflush() is a combination of a printf() followed by a fflush(stdout).
// The flushing is necessary to put the caiaio immediately on a job.

int prflush(char *fmt, ...)
{
  int r;
  va_list ap;
  va_start(ap, fmt);
  r = vprintf(fmt, ap);
  va_end(ap);
  fflush(stdout);
  return r;
}

// fprflush() is a combination of a fprintf(stream, ...) and a fflush(stream).
// In this program only fprintf(stderr, ...) and fflush(stderr) is used.

int fprflush(FILE *stream, char *fmt, ...)
{
  int r;
  va_list ap;
  va_start(ap, fmt);
  r = vfprintf(stream, fmt, ap);
  va_end(ap);
  fflush(stream);
  return r;
}

int main (int argc, char *argv[])
{
  FILE *instr = NULL;
  int i, ngames;
  int answer1, answer2, answer3, answer4, answer5, answer6, answer7, answer8;
  char dummy[80], buf1[80], buf2[80], buf3[80], buf4[80], buf5[80], buf6[80], buf7[80], buf8[80], buf9[80], buf10[80];
  
  if (argc >= 2) instr = fopen(argv[1], "r");
  else instr = fopen("manager.txt", "r");
  if (instr == NULL) 
  {
    fprflush(stderr, "Non-existing filename\n");
    prflush("I stop_caiaio\n");
    return 1;
  }

// Read the number of games to be played:
  
  fscanf(instr, "%d", &ngames);
  for (i=0; i<ngames; i++)
  {

// Read the names of both players and the log files:
    
    fscanf(instr, "%s", buf1);
    fscanf(instr, "%s", buf2);
    fscanf(instr, "%s", buf3);
    fscanf(instr, "%s", buf4);
    fscanf(instr, "%s", buf5);
    fscanf(instr, "%s", buf6);
    fscanf(instr, "%s", buf7);
    fscanf(instr, "%s", buf8);

// Report about the game:
    
    fprflush(stderr, "M: GAME %d = %s <> %s <> %s <> %s\n", i+1, buf1, buf3, buf5, buf7);

    LOCK(dummy);
    
// Inform the cacaio that there are 4 players:
    
    prflush("I number_players 4\n");
    
// Inform the cacaio who player 1 is and where its stderr can be printed to;
// the playing time for player 1 is 20000 milliseconds:
    
    prflush("I player 1 %s 20000 ../playerlogs/%s\n", buf1, buf2);

// After that, start the player and wait 100 milliseconds for the firsterror:
// (for more details: see the Caia documentation)
    
    prflush("I start 1 100\n");

// The are two possibilities:
// 1. "no_firsterror" is returned by the caiaio if the player did not printed anything
//    to its stderr since 100 milliseconds after being started.
// 2. "firsterror string1 string2" is returned by the caiaio. In this case the player
//    must return two strings in order to identify himself.
//
// Use "I start 1\n" if no firsterror is expected or used!
// In that case the next 7 lines should be ommited as well:
    
    scanf("%s", buf9);
    if (!strcmp(buf9, "firsterror"))
    {
      scanf("%s", buf9);
      scanf("%s", buf10);
      fprintf(stderr, "M: player 1 = %s %s\n", buf9, buf10); fflush(stderr);
    }

// Repeat for player 2 to 4:
    
    prflush("I player 2 %s 20000 ../playerlogs/%s\n", buf3, buf4);
    prflush("I start 2 100\n");
    scanf("%s", buf9);
    if (!strcmp(buf9, "firsterror"))
    {
      scanf("%s", buf9);
      scanf("%s", buf10);
      fprintf(stderr, "M: player 2 = %s %s\n", buf9, buf10); fflush(stderr);
    }
    
    prflush("I player 3 %s 20000 ../playerlogs/%s\n", buf5, buf6);
    prflush("I start 3 100\n");
    scanf("%s", buf9);
    if (!strcmp(buf9, "firsterror"))
    {
      scanf("%s", buf9);
      scanf("%s", buf10);
      fprintf(stderr, "M: player 3 = %s %s\n", buf9, buf10); fflush(stderr);
    }
    
    prflush("I player 4 %s 20000 ../playerlogs/%s\n", buf7, buf8);
    prflush("I start 4 100\n");
    scanf("%s", buf9);
    if (!strcmp(buf9, "firsterror"))
    {
      scanf("%s", buf9);
      scanf("%s", buf10);
      fprintf(stderr, "M: player 4 = %s %s\n", buf9, buf10); fflush(stderr);
    }
    
    UNLOCK;

// Put the referee on a job and provide him a unique file name:
// You must be unlocked before giving this command to the cacaio!
    
    prflush("I referee referee ../refereelogs/referee.%s-%s-%s-%s.log\n", buf1, buf3, buf5, buf7);

// The referee sends back: "points1 points2 points3 points4 time1 time2 time3 time4\n":
// The referee must be written this way to do this!
    
    scanf("%d", &answer1); // points1
    scanf("%d", &answer2); // points2
    scanf("%d", &answer3); // points3
    scanf("%d", &answer4); // points4
    scanf("%d", &answer5); // time1
    scanf("%d", &answer6); // time2
    scanf("%d", &answer7); // time3
    scanf("%d", &answer8); // time4
    fprflush(stderr, "M: REPORT = %d %d %d %d (time = %d %d %d %d)\n", answer1, answer2, answer3, answer4, answer5, answer6, answer7, answer8);

// Make sure all 5 processes are killed:
    
    prflush("I kill_referee\n");
    prflush("I kill 1\n");
    prflush("I kill 2\n");
    prflush("I kill 3\n");
    prflush("I kill 4\n");
  }

// Tell the cacaio he stops himself:
  
  prflush("I stop_caiaio\n");
  return 0;
}



