/* Copyright (C) 2005 Jaap Taal and Marcel Vlastuin.

This file is part of the Caia project. This project can be
downloaded from the website www.codecup.nl. You can email to
marcel@vlastuin.net or write to Marcel Vlastuin, Perenstraat 40,
2564 SE Den Haag, The Netherlands.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; see the file COPYING.  If not, write to
the Free Software Foundation, 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <errno.h>

#define LOCK printf("I lock\n"); fflush(stdout); do scanf("%s", invoer); while (strcmp(invoer, "lock_ok"))
#define UNLOCK printf("I unlock\n"); fflush(stdout)


#define VLAG 1
#define BOM 2
#define GENERAAL 3
#define OVERSTE 4
#define LUITENANT 5
#define MONTEUR 6
#define RUITER 7
#define SPION 8

#define SCHUIF 0
#define SLA 1

int a[47]=
{
  -36,-37,-38,-39,-40,-41,-42,  //  0  1  2  3  4  5  6
  -29,-30,-31,-32,-33,-34,-35,  //  7  8  9 10 11 12 13
  -22,-23,-24,-25,-26,-27,-28,  // 14 15 16 17 18 19 20
    0,      0,  0,  0,      0,  // 21 XX 22 23 24 XX 25
    1,  2,  3,  4,  5,  6,  7,  // 26 27 28 29 30 31 32
    8,  9, 10, 11, 12, 13, 14,  // 33 34 35 36 37 38 39
   15, 16, 17, 18, 19, 20, 21   // 40 41 42 43 44 45 46
};

int b[47][5]=
{
  { 1, 7,-1},            //  0
  { 0, 2, 8,-1},         //  1
  { 1, 3, 9,-1},         //  2
  { 2, 4,10,-1},         //  3
  { 3, 5,11,-1},         //  4
  { 4, 6,12,-1},         //  5
  { 5,13,-1},            //  6

  { 0, 8,14,-1},         //  7
  { 1, 7, 9,15,-1},      //  8
  { 2, 8,10,16,-1},      //  9
  { 3, 9,11,17,-1},      // 10
  { 4,10,12,18,-1},      // 11
  { 5,11,13,19,-1},      // 12
  { 6,12,20,-1},         // 13

  { 7,15,21,-1},         // 14
  { 8,14,16,-1},         // 15
  { 9,15,17,22,-1},      // 16
  {10,16,18,23,-1},      // 17
  {11,17,19,24,-1},      // 18
  {12,18,20,-1},         // 19
  {13,19,25,-1},         // 20

  {14,26,-1},            // 21
  {16,23,28,-1},         // 22
  {17,22,24,29,-1},      // 23
  {18,23,30,-1},         // 24
  {20,32,-1},            // 25
  
  {21,27,33,-1},         // 26
  {26,28,34,-1},         // 27
  {22,27,29,35,-1},      // 28
  {23,28,30,36,-1},      // 29
  {24,29,31,37,-1},      // 30
  {30,32,38,-1},         // 31
  {25,31,39,-1},         // 32

  {26,34,40,-1},         // 33
  {27,33,35,41,-1},      // 34
  {28,34,36,42,-1},      // 35
  {29,35,37,43,-1},      // 36
  {30,36,38,44,-1},      // 37
  {31,37,39,45,-1},      // 38
  {32,38,46,-1},         // 39

  {33,41,-1},            // 40
  {34,40,42,-1},         // 41
  {35,41,43,-1},         // 42
  {36,42,44,-1},         // 43
  {37,43,45,-1},         // 44
  {38,44,46,-1},         // 45
  {39,45,-1}             // 46
};

int swit[9]={0,1,4,1,2,3,4,5,1};
int szwart[9]={0,1,4,1,2,3,4,5,1};
int sbekend[43];
int sstatus[43];
int overwit=16, overzwart=16;

int zet[1000][5]=
{
  {1, 33, 21},
  {1,  7, 21}
};
int pvul;


char hulp1(int x)
{
  switch(x)
  {
    case 0: return ' ';
    case 1: return 'V';
    case 2: return 'B';
    case 3: return 'G';
    case 4: return 'O';
    case 5: return 'L';
    case 6: return 'M';
    case 7: return 'R';
    case 8: return 'S';
  }
  return ' ';
}

char hulp2(int x)
{
  switch(x)
  {
    case 0: return ' ';
    case 1: return '!';
    case 2: return ' ';
  }
  return ' ';
}

void printbord(void)
{
  int i, h[43];
  return;
  fprintf(stderr, "\n\n                 ");
  for (i=0; i<47; ++i)
  {
    if (i==22 || i==25) fprintf(stderr, "  ##");
    if (a[i]==0) fprintf(stderr, "  .."); else fprintf(stderr, " %3d", a[i]);
    if (i==6 || i==13 || i==20 || i==25 || i==32 || i==39 || i==46) fprintf(stderr, "\n\n                 ");
  }
  fprintf(stderr, "\n       V  B  G  O  L  M  R  S          V  B  G  O  L  M  R  S \n");
  fprintf(stderr, "  %3d", overwit);
  for (i=1; i<9; ++i) fprintf(stderr, "%3d", swit[i]);
  fprintf(stderr, "   ");
  fprintf(stderr, "  %3d", overzwart);
  for (i=1; i<9; ++i) fprintf(stderr, "%3d", szwart[i]);
  fprintf(stderr, "\n\n       nn   bk bw                      nn   bk bw\n\n");
  for (i=1; i<43; ++i) h[i]=0;
  for (i=0; i<47; ++i) if (a[i]) h[abs(a[i])]=1;
  for (i=1; i<22; ++i)
  {
    if (h[i]) fprintf(stderr, "      %3d    %c  %c", i, hulp1(sbekend[i]), hulp2(sstatus[i]));
    else fprintf(stderr, "                 ");
    if (h[i+21]) fprintf(stderr, "                     %3d    %c  %c\n", -i-21, hulp1(sbekend[i+21]), hulp2(sstatus[i+21]));
    else fprintf(stderr, "\n");
  }
  fflush(stderr);
}

int doezetwit(int x, int *y, int *z)
{
  *y=a[zet[x][1]];
  *z=-a[zet[x][2]];
  if (zet[x][0]==SCHUIF)
  {
    a[zet[x][2]]=*y;
    a[zet[x][1]]=0;
    switch(sstatus[*y])
    {
      case 0: sstatus[*y]=1;
              --overwit;
              return 0;
      case 1: return 1;
      case 2: return 2;
    }
  }
  else
  {
    switch(10*zet[x][3]+zet[x][4])
    {
//    case 11: goto kanniet;
//    case 18: goto kanniet;

//    case 21: goto kanniet;
//    case 28: goto kanniet;

//    case 31: goto kanniet;
      case 32: goto bomwint;
      case 33: goto beide;
      case 34: goto aanvallerwint;
      case 35: goto aanvallerwint;
      case 36: goto aanvallerwint;
      case 37: goto aanvallerwint;
      case 38: goto aanvallerwint;

//    case 41: goto kanniet;
      case 42: goto bomwint;
      case 43: goto verdedigerwint;
      case 44: goto beide;
      case 45: goto aanvallerwint;
      case 46: goto aanvallerwint;
      case 47: goto aanvallerwint;
      case 48: goto aanvallerwint;

//    case 51: goto kanniet;
      case 52: goto bomwint;
      case 53: goto verdedigerwint;
      case 54: goto verdedigerwint;
      case 55: goto beide;
      case 56: goto aanvallerwint;
      case 57: goto aanvallerwint;
      case 58: goto aanvallerwint;

//    case 61: goto kanniet;
      case 62: goto bomverliest;
      case 63: goto verdedigerwint;
      case 64: goto verdedigerwint;
      case 65: goto verdedigerwint;
      case 66: goto beide;
      case 67: goto aanvallerwint;
      case 68: goto aanvallerwint;

//    case 71: goto kanniet;
      case 72: goto bomwint;
      case 73: goto verdedigerwint;
      case 74: goto verdedigerwint;
      case 75: goto verdedigerwint;
      case 76: goto verdedigerwint;
      case 77: goto beide;
      case 78: goto aanvallerwint;

//    case 81: goto kanniet;
      case 82: goto bomwint;
      case 83: goto aanvallerwint;
      case 84: goto verdedigerwint;
      case 85: goto verdedigerwint;
      case 86: goto verdedigerwint;
      case 87: goto verdedigerwint;
      case 88: goto beide;
    }

//kanniet:
    printf("Fout.1\n");
    exit(13);

beide:
    a[zet[x][1]]=0;
    a[zet[x][2]]=0;
    switch(10*sstatus[*y]+sstatus[*z])
    {
//    case  0: kanniet;
      case 10: --swit[zet[x][3]];
               --szwart[zet[x][4]];
               --overzwart;
               return 110;
      case 20: --szwart[zet[x][4]];
               --overzwart;
               return 120;
      case  1: --swit[zet[x][3]];
               --overwit;
               --szwart[zet[x][4]];
               return 101;
      case  2: --swit[zet[x][3]];
               --overwit;
               return 102;
      case 11: --swit[zet[x][3]];
               --szwart[zet[x][4]];
               return 111;
      case 21: --szwart[zet[x][4]];
               return 121;
      case 12: --swit[zet[x][3]];
               return 112;
      case 22: return 122;
    }
    
aanvallerwint:
    a[zet[x][1]]=0;
    a[zet[x][2]]=*y;
    switch(10*sstatus[*y]+sstatus[*z])
    {
//    case  0: kanniet;
      case 10: --swit[sbekend[*y]=zet[x][3]];
               sstatus[*y]=2;
               --szwart[zet[x][4]];
               --overzwart;
               return 210;
      case 20: --szwart[zet[x][4]];
               --overzwart;
               return 220;
      case  1: --swit[sbekend[*y]=zet[x][3]];
               sstatus[*y]=2;
               --overwit;
               --szwart[zet[x][4]];
               return 201;
      case  2: --swit[sbekend[*y]=zet[x][3]];
               sstatus[*y]=2;
               --overwit;
               return 202;
      case 11: --swit[sbekend[*y]=zet[x][3]];
               sstatus[*y]=2;
               --szwart[zet[x][4]];
               return 211;
      case 21: --szwart[zet[x][4]];
               return 221;
      case 12: --swit[sbekend[*y]=zet[x][3]];
               sstatus[*y]=2;
               return 212;
      case 22: return 222;
    }
    
verdedigerwint:
    a[zet[x][1]]=0;
    switch(10*sstatus[*y]+sstatus[*z])
    {
//    case  0: kanniet;
      case 10: --swit[zet[x][3]];
               --szwart[sbekend[*z]=zet[x][4]];
               sstatus[*z]=2;
               --overzwart;
               return 310;
      case 20: --szwart[sbekend[*z]=zet[x][4]];
               sstatus[*z]=2;
               --overzwart;
               return 320;
      case  1: --swit[zet[x][3]];
               --overwit;
               --szwart[sbekend[*z]=zet[x][4]];
               sstatus[*z]=2;
               return 301;
      case  2: --swit[zet[x][3]];
               --overwit;
               return 302;
      case 11: --swit[zet[x][3]];
               --szwart[sbekend[*z]=zet[x][4]];
               sstatus[*z]=2;
               return 311;
      case 21: --szwart[sbekend[*z]=zet[x][4]];
               sstatus[*z]=2;
               return 321;
      case 12: --swit[zet[x][3]];
               return 312;
      case 22: return 322;
    }

bomwint:
    a[zet[x][1]]=0;
    switch(10*sstatus[*y]+sstatus[*z])
    {
//    case  0: kanniet;
      case 10: --swit[zet[x][3]];
               --szwart[sbekend[*z]=BOM];
               sstatus[*z]=2;
               return 410;
      case 20: --szwart[sbekend[*z]=BOM];
               sstatus[*z]=2;
               return 420;
//    case  1: kanniet;
//    case  2: kanniet;
//    case 11: kanniet;
//    case 21: kanniet;
      case 12: --swit[zet[x][3]];
               return 412;
      case 22: return 422;
    }

bomverliest:
    a[zet[x][1]]=0;
    a[zet[x][2]]=*y;
    switch(10*sstatus[*y]+sstatus[*z])
    {
//    case  0: kanniet;
      case 10: --swit[sbekend[*y]=MONTEUR];
               sstatus[*y]=2;
               --szwart[BOM];
               return 510;
      case 20: --szwart[BOM];
               return 520;
//    case  1: kanniet;
//    case  2: kanniet;
//    case 11: kanniet;
//    case 21: kanniet;
      case 12: --swit[sbekend[*y]=MONTEUR];
               sstatus[*y]=2;
               return 512;
      case 22: return 522;
    }
  }
  return 13;
}

void herstelzetwit(int x, int y, int z, int status)
{
  a[zet[x][1]]=y;
  a[zet[x][2]]=-z;
  if (zet[x][0]==SCHUIF)
  {
    switch(status)
    {
      case 0: sstatus[y]=0;
              ++overwit;
              return;
      case 1: sstatus[y]=1;
              return;
      case 2: sstatus[y]=2;
              return;
    }
  }
  else
  {
    switch(status)
    {
//beide:
      case 110: ++swit[zet[x][3]];
                ++szwart[zet[x][4]];
                ++overzwart;
                return;
      case 120: ++szwart[zet[x][4]];
                ++overzwart;
                return;
      case 101: ++swit[zet[x][3]];
                ++overwit;
                ++szwart[zet[x][4]];
                return;
      case 102: ++swit[zet[x][3]];
                ++overwit;
                return;
      case 111: ++swit[zet[x][3]];
                ++szwart[zet[x][4]];
                return;
      case 121: ++szwart[zet[x][4]];
                return;
      case 112: ++swit[zet[x][3]];
                return;
      case 122: return;
      
//aanvallerwint:
      case 210: ++swit[zet[x][3]];
                sbekend[y]=0;
                sstatus[y]=1;
                ++szwart[zet[x][4]];
                ++overzwart;
                return;
      case 220: ++szwart[zet[x][4]];
                ++overzwart;
                return;
      case 201: ++swit[zet[x][3]];
                sbekend[y]=0;
                sstatus[y]=0;
                ++overwit;
                ++szwart[zet[x][4]];
                return;
      case 202: ++swit[zet[x][3]];
                sbekend[y]=0;
                sstatus[y]=0;
                ++overwit;
                return;
      case 211: ++swit[zet[x][3]];
                sbekend[y]=0;
                sstatus[y]=1;
                ++szwart[zet[x][4]];
                return;
      case 221: ++szwart[zet[x][4]];
                return;
      case 212: ++swit[zet[x][3]];
                sbekend[y]=0;
                sstatus[y]=1;
                return;
      case 222: return;

//verdedigerwint:
      case 310: ++swit[zet[x][3]];
                ++szwart[zet[x][4]];
                sbekend[z]=0;
                sstatus[z]=0;
                ++overzwart;
                return;
      case 320: ++szwart[zet[x][4]];
                sbekend[z]=0;
                sstatus[z]=0;
                ++overzwart;
                return;
      case 301: ++swit[zet[x][3]];
                ++overwit;
                ++szwart[zet[x][4]];
                sbekend[z]=0;
                sstatus[z]=1;
                return;
      case 302: ++swit[zet[x][3]];
                ++overwit;
                return;
      case 311: ++swit[zet[x][3]];
                ++szwart[zet[x][4]];
                sbekend[z]=0;
                sstatus[z]=1;
                return;
      case 321: ++szwart[zet[x][4]];
                sbekend[z]=0;
                sstatus[z]=1;
                return;
      case 312: ++swit[zet[x][3]];
                return;
      case 322: return;

//bomwint:
      case 410: ++swit[zet[x][3]];
                ++szwart[BOM];
                sbekend[z]=0;
                sstatus[z]=0;
                return;
      case 420: ++szwart[BOM];
                sbekend[z]=0;
                sstatus[z]=0;
                return;
      case 412: ++swit[zet[x][3]];
                return;
      case 422: return;

//bomverliest:
      case 510: ++swit[MONTEUR];
                sbekend[y]=0;
                sstatus[y]=1;
                ++szwart[BOM];
                return;
      case 520: ++szwart[BOM];
                return;
      case 512: ++swit[MONTEUR];
                sbekend[y]=0;
                sstatus[y]=1;
                return;
      case 522: return;
    }
  }
}

int doezetzwart(int x, int *y, int *z)
{
  *y=-a[zet[x][1]];
  *z=a[zet[x][2]];
  if (zet[x][0]==SCHUIF)
  {
    a[zet[x][2]]=-*y;
    a[zet[x][1]]=0;
    switch(sstatus[*y])
    {
      case 0: sstatus[*y]=1;
              --overzwart;
              return 0;
      case 1: return 1;
      case 2: return 2;
    }
  }
  else
  {
    switch(10*zet[x][3]+zet[x][4])
    {
//    case 11: goto kanniet;
//    case 18: goto kanniet;

//    case 21: goto kanniet;
//    case 28: goto kanniet;

//    case 31: goto kanniet;
      case 32: goto bomwint;
      case 33: goto beide;
      case 34: goto aanvallerwint;
      case 35: goto aanvallerwint;
      case 36: goto aanvallerwint;
      case 37: goto aanvallerwint;
      case 38: goto aanvallerwint;

//    case 41: goto kanniet;
      case 42: goto bomwint;
      case 43: goto verdedigerwint;
      case 44: goto beide;
      case 45: goto aanvallerwint;
      case 46: goto aanvallerwint;
      case 47: goto aanvallerwint;
      case 48: goto aanvallerwint;

//    case 51: goto kanniet;
      case 52: goto bomwint;
      case 53: goto verdedigerwint;
      case 54: goto verdedigerwint;
      case 55: goto beide;
      case 56: goto aanvallerwint;
      case 57: goto aanvallerwint;
      case 58: goto aanvallerwint;

//    case 61: goto kanniet;
      case 62: goto bomverliest;
      case 63: goto verdedigerwint;
      case 64: goto verdedigerwint;
      case 65: goto verdedigerwint;
      case 66: goto beide;
      case 67: goto aanvallerwint;
      case 68: goto aanvallerwint;

//    case 71: goto kanniet;
      case 72: goto bomwint;
      case 73: goto verdedigerwint;
      case 74: goto verdedigerwint;
      case 75: goto verdedigerwint;
      case 76: goto verdedigerwint;
      case 77: goto beide;
      case 78: goto aanvallerwint;

//    case 81: goto kanniet;
      case 82: goto bomwint;
      case 83: goto aanvallerwint;
      case 84: goto verdedigerwint;
      case 85: goto verdedigerwint;
      case 86: goto verdedigerwint;
      case 87: goto verdedigerwint;
      case 88: goto beide;
    }
  
//kanniet:
    printf("Fout.2 %d\n", 10*zet[x][3]+zet[x][4]);
    exit(13);
    
beide:
    a[zet[x][1]]=0;
    a[zet[x][2]]=0;
    switch(10*sstatus[*y]+sstatus[*z])
    {
//    case  0: kanniet;
      case 10: --szwart[zet[x][3]];
               --swit[zet[x][4]];
               --overwit;
               return 110;
      case 20: --swit[zet[x][4]];
               --overwit;
               return 120;
      case  1: --szwart[zet[x][3]];
               --overzwart;
               --swit[zet[x][4]];
               return 101;
      case  2: --szwart[zet[x][3]];
               --overzwart;
               return 102;
      case 11: --szwart[zet[x][3]];
               --swit[zet[x][4]];
               return 111;
      case 21: --swit[zet[x][4]];
               return 121;
      case 12: --szwart[zet[x][3]];
               return 112;
      case 22: return 122;
    }
    
aanvallerwint:
    a[zet[x][1]]=0;
    a[zet[x][2]]=-*y;
    switch(10*sstatus[*y]+sstatus[*z])
    {
//    case  0: kanniet;
      case 10: --szwart[sbekend[*y]=zet[x][3]];
               sstatus[*y]=2;
               --swit[zet[x][4]];
               --overwit;
               return 210;
      case 20: --swit[zet[x][4]];
               --overwit;
               return 220;
      case  1: --szwart[sbekend[*y]=zet[x][3]];
               sstatus[*y]=2;
               --overzwart;
               --swit[zet[x][4]];
               return 201;
      case  2: --szwart[sbekend[*y]=zet[x][3]];
               sstatus[*y]=2;
               --overzwart;
               return 202;
      case 11: --szwart[sbekend[*y]=zet[x][3]];
               sstatus[*y]=2;
               --swit[zet[x][4]];
               return 211;
      case 21: --swit[zet[x][4]];
               return 221;
      case 12: --szwart[sbekend[*y]=zet[x][3]];
               sstatus[*y]=2;
               return 212;
      case 22: return 222;
    }
    
verdedigerwint:
    a[zet[x][1]]=0;
    switch(10*sstatus[*y]+sstatus[*z])
    {
//    case  0: kanniet;
      case 10: --szwart[zet[x][3]];
               --swit[sbekend[*z]=zet[x][4]];
               sstatus[*z]=2;
               --overwit;
               return 310;
      case 20: --swit[sbekend[*z]=zet[x][4]];
               sstatus[*z]=2;
               --overwit;
               return 320;
      case  1: --szwart[zet[x][3]];
               --overzwart;
               --swit[sbekend[*z]=zet[x][4]];
               sstatus[*z]=2;
               return 301;
      case  2: --szwart[zet[x][3]];
               --overzwart;
               return 302;
      case 11: --szwart[zet[x][3]];
               --swit[sbekend[*z]=zet[x][4]];
               sstatus[*z]=2;
               return 311;
      case 21: --swit[sbekend[*z]=zet[x][4]];
               sstatus[*z]=2;
               return 321;
      case 12: --szwart[zet[x][3]];
               return 312;
      case 22: return 322;
    }

bomwint:
    a[zet[x][1]]=0;
    switch(10*sstatus[*y]+sstatus[*z])
    {
//    case  0: kanniet;
      case 10: --szwart[zet[x][3]];
               --swit[sbekend[*z]=BOM];
               sstatus[*z]=2;
               return 410;
      case 20: --swit[sbekend[*z]=BOM];
               sstatus[*z]=2;
               return 420;
//    case  1: kanniet;
//    case  2: kanniet;
//    case 11: kanniet;
//    case 21: kanniet;
      case 12: --szwart[zet[x][3]];
               return 412;
      case 22: return 422;
    }

bomverliest:
    a[zet[x][1]]=0;
    a[zet[x][2]]=-*y;
    switch(10*sstatus[*y]+sstatus[*z])
    {
//    case  0: kanniet;
      case 10: --szwart[sbekend[*y]=MONTEUR];
               sstatus[*y]=2;
               --swit[BOM];
               return 510;
      case 20: --swit[BOM];
               return 520;
//    case  1: kanniet;
//    case  2: kanniet;
//    case 11: kanniet;
//    case 21: kanniet;
      case 12: --szwart[sbekend[*y]=MONTEUR];
               sstatus[*y]=2;
               return 512;
      case 22: return 522;
    }
  }
  return 13;
}

void herstelzetzwart(int x, int y, int z, int status)
{
  a[zet[x][1]]=-y;
  a[zet[x][2]]=z;
  if (zet[x][0]==SCHUIF)
  {
    switch(status)
    {
      case 0: sstatus[y]=0;
              ++overzwart;
              return;
      case 1: sstatus[y]=1;
              return;
      case 2: sstatus[y]=2;
              return;
    }
  }
  else
  {
    switch(status)
    {
//beide:
      case 110: ++szwart[zet[x][3]];
                ++swit[zet[x][4]];
                ++overwit;
                return;
      case 120: ++swit[zet[x][4]];
                ++overwit;
                return;
      case 101: ++szwart[zet[x][3]];
                ++overzwart;
                ++swit[zet[x][4]];
                return;
      case 102: ++szwart[zet[x][3]];
                ++overzwart;
                return;
      case 111: ++szwart[zet[x][3]];
                ++swit[zet[x][4]];
                return;
      case 121: ++swit[zet[x][4]];
                return;
      case 112: ++szwart[zet[x][3]];
                return;
      case 122: return;
      
//aanvallerwint:
      case 210: ++szwart[zet[x][3]];
                sbekend[y]=0;
                sstatus[y]=1;
                ++swit[zet[x][4]];
                ++overwit;
                return;
      case 220: ++swit[zet[x][4]];
                ++overwit;
                return;
      case 201: ++szwart[zet[x][3]];
                sbekend[y]=0;
                sstatus[y]=0;
                ++overzwart;
                ++swit[zet[x][4]];
                return;
      case 202: ++szwart[zet[x][3]];
                sbekend[y]=0;
                sstatus[y]=0;
                ++overzwart;
                return;
      case 211: ++szwart[zet[x][3]];
                sbekend[y]=0;
                sstatus[y]=1;
                ++swit[zet[x][4]];
                return;
      case 221: ++swit[zet[x][4]];
                return;
      case 212: ++szwart[zet[x][3]];
                sbekend[y]=0;
                sstatus[y]=1;
                return;
      case 222: return;

//verdedigerwint:
      case 310: ++szwart[zet[x][3]];
                ++swit[zet[x][4]];
                sbekend[z]=0;
                sstatus[z]=0;
                ++overwit;
                return;
      case 320: ++swit[zet[x][4]];
                sbekend[z]=0;
                sstatus[z]=0;
                ++overwit;
                return;
      case 301: ++szwart[zet[x][3]];
                ++overzwart;
                ++swit[zet[x][4]];
                sbekend[z]=0;
                sstatus[z]=1;
                return;
      case 302: ++szwart[zet[x][3]];
                ++overzwart;
                return;
      case 311: ++szwart[zet[x][3]];
                ++swit[zet[x][4]];
                sbekend[z]=0;
                sstatus[z]=1;
                return;
      case 321: ++swit[zet[x][4]];
                sbekend[z]=0;
                sstatus[z]=1;
                return;
      case 312: ++szwart[zet[x][3]];
                return;
      case 322: return;

//bomwint:
      case 410: ++szwart[zet[x][3]];
                ++swit[BOM];
                sbekend[z]=0;
                sstatus[z]=0;
                return;
      case 420: ++swit[BOM];
                sbekend[z]=0;
                sstatus[z]=0;
                return;
      case 412: ++szwart[zet[x][3]];
                return;
      case 422: return;
      
//bomverliest:
      case 510: ++szwart[MONTEUR];
                sbekend[y]=0;
                sstatus[y]=1;
                ++swit[BOM];
                return;
      case 520: ++swit[BOM];
                return;
      case 512: ++szwart[MONTEUR];
                sbekend[y]=0;
                sstatus[y]=1;
                return;
      case 522: return;
    }
  }
}

void zoekzetwit(int his)
{
  int i, j, k, l, h1=zet[his][0], h2=zet[his][1], h3=zet[his][2];
  for (i=0; i<47; ++i)
  {
    if (a[i]<=0) continue;
    if (sbekend[a[i]]==BOM) continue;
    if (!overwit && !sstatus[a[i]]) continue;
    j=0;
    do
    {
      if (!a[b[i][j]])
      {
        if (h1==SCHUIF && h2==b[i][j] && h3==i) continue;
        zet[pvul][0]=SCHUIF;
        zet[pvul][1]=i;
        zet[pvul++][2]=b[i][j];
      }
      else if (a[b[i][j]]<0)
      {
        if (sbekend[a[i]])
        {
          if (sbekend[-a[b[i][j]]])
          {
            zet[pvul][0]=SLA;
            zet[pvul][1]=i;
            zet[pvul][2]=b[i][j];
            zet[pvul][3]=sbekend[a[i]];
            zet[pvul++][4]=sbekend[-a[b[i][j]]];
          }  
          else
          {
            for (l=1; l<9; ++l)
            {
              if (l<3 && sstatus[-a[b[i][j]]]==1) continue;
              if (l>2 && !sstatus[-a[b[i][j]]] && !overzwart) continue;
              if (szwart[l])
              {
                zet[pvul][0]=SLA;
                zet[pvul][1]=i;
                zet[pvul][2]=b[i][j];
                zet[pvul][3]=sbekend[a[i]];
                zet[pvul++][4]=l;
              }  
            }  
          }
        }
        else
        {
          for (k=3; k<9; ++k)
          {
            if (swit[k])
            {
              if (sbekend[-a[b[i][j]]])
              {
                zet[pvul][0]=SLA;
                zet[pvul][1]=i;
                zet[pvul][2]=b[i][j];
                zet[pvul][3]=k;
                zet[pvul++][4]=sbekend[-a[b[i][j]]];
              }  
              else
              {
                for (l=1; l<9; ++l)
                {
                  if (l<3 && sstatus[-a[b[i][j]]]==1) continue;
                  if (l>2 && !sstatus[-a[b[i][j]]] && !overzwart) continue;
                  if (szwart[l])
                  {
                    zet[pvul][0]=SLA;
                    zet[pvul][1]=i;
                    zet[pvul][2]=b[i][j];
                    zet[pvul][3]=k;
                    zet[pvul++][4]=l;
                  }  
                }  
              }
            }
          }
        }
      }
    } while (b[i][++j]!=-1);
  }
}

void zoekzetzwart(int his)
{
  int i, j, k, l, h1=zet[his][0], h2=zet[his][1], h3=zet[his][2];
  for (i=0; i<47; ++i)
  {
    if (a[i]>=0) continue;
    if (sbekend[-a[i]]==BOM) continue;
    if (!overzwart && !sstatus[-a[i]]) continue;
    j=0;
    do
    {
      if (!a[b[i][j]])
      {
        if (h1==SCHUIF && h2==b[i][j] && h3==i) continue;
        zet[pvul][0]=SCHUIF;
        zet[pvul][1]=i;
        zet[pvul++][2]=b[i][j];
      }
      else if (a[b[i][j]]>0)
      {
        if (sbekend[-a[i]])
        {
          if (sbekend[a[b[i][j]]])
          {
            zet[pvul][0]=SLA;
            zet[pvul][1]=i;
            zet[pvul][2]=b[i][j];
            zet[pvul][3]=sbekend[-a[i]];
            zet[pvul++][4]=sbekend[a[b[i][j]]];
          }  
          else
          {
            for (l=1; l<9; ++l)
            {
              if (l<3 && sstatus[a[b[i][j]]]==1) continue;
              if (l>2 && !sstatus[a[b[i][j]]] && !overwit) continue;
              if (swit[l])
              {
                zet[pvul][0]=SLA;
                zet[pvul][1]=i;
                zet[pvul][2]=b[i][j];
                zet[pvul][3]=sbekend[-a[i]];
                zet[pvul++][4]=l;
              }  
            }  
          }
        }
        else
        {
          for (k=3; k<9; ++k)
          {
            if (szwart[k])
            {
              if (sbekend[a[b[i][j]]])
              {
                zet[pvul][0]=SLA;
                zet[pvul][1]=i;
                zet[pvul][2]=b[i][j];
                zet[pvul][3]=k;
                zet[pvul++][4]=sbekend[a[b[i][j]]];
              }  
              else
              {
                for (l=1; l<9; ++l)
                {
                  if (l<3 && sstatus[a[b[i][j]]]==1) continue;
                  if (l>2 && !sstatus[a[b[i][j]]] && !overwit) continue;
                  if (swit[l])
                  {
                    zet[pvul][0]=SLA;
                    zet[pvul][1]=i;
                    zet[pvul][2]=b[i][j];
                    zet[pvul][3]=k;
                    zet[pvul++][4]=l;
                  }  
                }  
              }
            }
          }
        }
      }
    } while (b[i][++j]!=-1);
  }
}

char *vertaalzet(int x)
{
  static char y[6];
  int f, t;
  f=zet[x][1];
  t=zet[x][2];
  if (f>24) ++f;
  if (f>21) ++f;
  if (t>24) ++t;
  if (t>21) ++t;
  if (t-f==1 || f-t==1)
  {
    y[0]=f%7+'a';
    y[1]=7-f/7+'0';
    y[3]=t%7+'a';
    y[4]=y[1];
  }
  else
  {
    y[0]=f%7+'a';
    y[1]=7-f/7+'0';
    y[3]=y[0];
    y[4]=7-t/7+'0';
  }
  y[2]='-';
  y[5]='\0';
  return y;
}

char *vertaalstuk1(int x)
{
  static char y[2];
  switch(zet[x][3])
  {
    case VLAG: y[0]='V'; break;
    case BOM: y[0]='B'; break;
    case GENERAAL: y[0]='G'; break;
    case OVERSTE: y[0]='O'; break;
    case LUITENANT: y[0]='L'; break;
    case MONTEUR: y[0]='M'; break;
    case RUITER: y[0]='R'; break;
    case SPION: y[0]='S'; break;
  }
  y[1]='\0';
  return y;
}

char *vertaalstuk2(int x)
{
  static char y[2];
  switch(zet[x][4])
  {
    case VLAG: y[0]='V'; break;
    case BOM: y[0]='B'; break;
    case GENERAAL: y[0]='G'; break;
    case OVERSTE: y[0]='O'; break;
    case LUITENANT: y[0]='L'; break;
    case MONTEUR: y[0]='M'; break;
    case RUITER: y[0]='R'; break;
    case SPION: y[0]='S'; break;
  }
  y[1]='\0';
  return y;
}

void voegtoeaanzet1(char x, int y)
{
  switch(x)
  {
    case 'V': zet[y][3]=VLAG; break;
    case 'B': zet[y][3]=BOM; break;
    case 'G': zet[y][3]=GENERAAL; break;
    case 'O': zet[y][3]=OVERSTE; break;
    case 'L': zet[y][3]=LUITENANT; break;
    case 'M': zet[y][3]=MONTEUR; break;
    case 'R': zet[y][3]=RUITER; break;
    case 'S': zet[y][3]=SPION; break;
    default:  zet[y][3]=-1;          
  }
  return;
}

void voegtoeaanzet2(char x, int y)
{
  switch(x)
  {
    case 'V': zet[y][4]=VLAG; break;
    case 'B': zet[y][4]=BOM; break;
    case 'G': zet[y][4]=GENERAAL; break;
    case 'O': zet[y][4]=OVERSTE; break;
    case 'L': zet[y][4]=LUITENANT; break;
    case 'M': zet[y][4]=MONTEUR; break;
    case 'R': zet[y][4]=RUITER; break;
    case 'S': zet[y][4]=SPION; break;
    default:  zet[y][4]=-1;          
  }
  return;
}

void vulzet(char *x, int y)
{
  int f, t;
  f=7*(7-x[1]+'0')+(x[0]-'a');
  t=7*(7-x[4]+'0')+(x[3]-'a');
  if (f>26) --f;
  if (f>22) --f;
  if (t>26) --t;
  if (t>22) --t;
  zet[y][1]=f;
  zet[y][2]=t;
  if (a[t]) zet[y][0]=SLA; else zet[y][0]=SCHUIF;
  return;
}

int main(int argc, char *argv[])
{
  int i, h1, h2, n=1, status=0, gevonden, witvlag=0, zwartvlag=0;
  int nwit, nzwart, pwit=0, pzwart=0, owit=0, ozwart=0;
  char invoer[100], fout[100], melding[100];
  FILE *log=NULL;

  if (argc>=2) 
  {
    log=fopen(argv[1], "w");
    if (log == NULL)
    {
      fprintf(stderr, "R: Cannot open the log file %s: %s\n", argv[1], strerror(errno));
      fflush(stderr);
    } else {
      fprintf(log, "Game log: %s\n\n", argv[1]);
    }
  }

  LOCK;
  printf("1 Start\n");

  do
  {
    pvul=4;
    zoekzetwit(0);
    if (pvul==4) {status=-2; break;}
    printf("I listen 1\n"); fflush(stdout);
    scanf("%s", invoer); strcpy(fout, invoer);
    vulzet(invoer, 2);
    gevonden=0;
    for (i=4; i<pvul; ++i)
      if (zet[2][0]==zet[i][0] &&
          zet[2][1]==zet[i][1] &&
          zet[2][2]==zet[i][2]) {gevonden=1; break;}
    if (!gevonden) {status=-3; break;}
    if (zet[2][0]==SLA)
    {
      witvlag=1;
      printf("I listen 1\n"); fflush(stdout);
      scanf("%s", invoer); strcpy(fout, invoer);
      voegtoeaanzet1(invoer[0], 2);
      gevonden=0;
      for (i=4; i<pvul; ++i)
        if (zet[2][0]==zet[i][0] &&
            zet[2][1]==zet[i][1] &&
            zet[2][2]==zet[i][2] &&
            zet[2][3]==zet[i][3]) {gevonden=1; break;}
      if (!gevonden) {status=-4; break;}
      UNLOCK;
      LOCK;
      if (zwartvlag) {printf("2 %s\n", vertaalstuk2(3)); zwartvlag=0;}
      printf("2 %s\n", vertaalzet(2));
      printf("I listen 2\n"); fflush(stdout);
      scanf("%s", invoer); strcpy(fout, invoer);
      voegtoeaanzet2(invoer[0], 2);
      gevonden=0;
      for (i=4; i<pvul; ++i)
        if (zet[2][0]==zet[i][0] &&
            zet[2][1]==zet[i][1] &&
            zet[2][2]==zet[i][2] &&
            zet[2][3]==zet[i][3] &&
            zet[2][4]==zet[i][4]) {gevonden=1; break;}
      if (!gevonden) {status=5; break;}
      if (zet[2][4]==VLAG) {status=1; break;}
      printf("2 %s\n", vertaalstuk1(2));
    }
    else
    {
      witvlag=0;
      UNLOCK;
      LOCK;
      if (zwartvlag) {printf("2 %s\n", vertaalstuk2(3)); zwartvlag=0;}
      printf("2 %s\n", vertaalzet(2));
    }
    doezetwit(2, &h1, &h2);
    if (log)
    {
      if (zet[2][0]==SLA)
      fprintf(log, "red   %2d: %s %s %s\n", n, vertaalzet(2), vertaalstuk1(2), vertaalstuk2(2));
      else
      fprintf(log, "red   %2d: %s\n", n, vertaalzet(2));
      fflush(log);
    }
    printbord();
    for (i=0; i<5; ++i) zet[0][i]=zet[2][i];

    pvul=4;
    zoekzetzwart(1);
    if (pvul==4) {status=2; break;}
    printf("I listen 2\n"); fflush(stdout);
    scanf("%s", invoer); strcpy(fout, invoer);
    vulzet(invoer, 3);
    gevonden=0;
    for (i=4; i<pvul; ++i)
      if (zet[3][0]==zet[i][0] &&
          zet[3][1]==zet[i][1] &&
          zet[3][2]==zet[i][2]) {gevonden=1; break;}
    if (!gevonden) {status=3; break;}
    if (zet[3][0]==SLA)
    {
      zwartvlag=1;
      printf("I listen 2\n"); fflush(stdout);
      scanf("%s", invoer); strcpy(fout, invoer);
      voegtoeaanzet1(invoer[0], 3);
      gevonden=0;
      for (i=4; i<pvul; ++i)
	if (zet[3][0]==zet[i][0] &&
	    zet[3][1]==zet[i][1] &&
	    zet[3][2]==zet[i][2] &&
	    zet[3][3]==zet[i][3]) {gevonden=1; break;}
      if (!gevonden) {status=4; break;}
      UNLOCK;
      LOCK;
      if (witvlag) {printf("1 %s\n", vertaalstuk2(2)); witvlag=0;}
      printf("1 %s\n", vertaalzet(3));
      printf("I listen 1\n"); fflush(stdout);
      scanf("%s", invoer); strcpy(fout, invoer);
      voegtoeaanzet2(invoer[0], 3);
      gevonden=0;
      for (i=4; i<pvul; ++i)
	if (zet[3][0]==zet[i][0] &&
	    zet[3][1]==zet[i][1] &&
	    zet[3][2]==zet[i][2] &&
	    zet[3][3]==zet[i][3] &&
	    zet[3][4]==zet[i][4]) {gevonden=1; break;}
      if (!gevonden) {status=-5; break;}
      if (zet[3][4]==VLAG) {status=-1; break;}
      printf("1 %s\n", vertaalstuk1(3));
    }
    else
    {
      zwartvlag=0;
      UNLOCK;
      LOCK;
      if (witvlag) {printf("1 %s\n", vertaalstuk2(2)); witvlag=0;}
      printf("1 %s\n", vertaalzet(3));
    }
    doezetzwart(3, &h1, &h2);
    if (log)
    {
      if (zet[3][0]==SLA)
      fprintf(log, "blue  %2d: %s %s %s\n", n, vertaalzet(3), vertaalstuk1(3), vertaalstuk2(3));
      else
      fprintf(log, "blue  %2d: %s\n", n, vertaalzet(3));
      fflush(log);
    }
    printbord();
    for (i=0; i<5; ++i) zet[1][i]=zet[3][i];
  } while (++n<=200);

  UNLOCK;

  nwit=0; nzwart=0;
  for (i=0; i<47; ++i)
  {
    if (a[i]<0) ++nzwart;
    else if (a[i]>0) ++nwit;
  }

  switch(status)
  {
    case  0: //400 zetten
             strcpy(melding, "A_draw_after_400_moves");
             if (zwartvlag) printf("2 %s\n", vertaalstuk2(3));
             sprintf(invoer, "\nNormal game end without a winner\n\n");
             if (nwit>nzwart) {pwit=3; pzwart=1; owit=0; ozwart=0;}
             else if (nwit<nzwart) {pwit=1; pzwart=3; owit=0; ozwart=0;}
             else {pwit=2; pzwart=2; owit=0; ozwart=0;}
             break;
    case -2: //zwart wint omdat wit geen zetten meer heeft
             strcpy(melding, "Blue_wins:_red_cannot_move");
             sprintf(invoer, "\nBlue wins because red cannot move anymore\n\n");
             pwit=0; pzwart=12; owit=0; ozwart=0;
             if (zwartvlag) {printf("2 %s\n", vertaalstuk2(3)); zwartvlag=0;}
             break;
    case -3: //wit heeft een illegale zet gedaan
             strcpy(melding, "Red_move_illegal");
             sprintf(invoer, "\nRed did an illegal move: %s\n\n", fout);
             pwit=0; pzwart=12; owit=1; ozwart=0;
             if (zwartvlag) {printf("2 %s\n", vertaalstuk2(3)); zwartvlag=0;}
             printf("2 X\n");
             break;
    case -4: //wit heeft een illegale zet gedaan als slazet
             strcpy(melding, "Reds_atacking_piece_is_illegal");
             sprintf(invoer, "\nRed's atacking piece was illegal: %s %s\n\n", vertaalzet(2), fout);
             pwit=0; pzwart=12; owit=1; ozwart=0;
             if (zwartvlag) {printf("2 %s\n", vertaalstuk2(3)); zwartvlag=0;}
             printf("2 X\n");
             break;
    case  1: //wit wint omdat de vlag gepakt is
             strcpy(melding, "Red_wins:_gets_the_flag");
             sprintf(invoer, "red   %2d: %s %s V\n\nRed wins because he captures the blue flag\n\n", n, vertaalzet(2), vertaalstuk1(2));
             pwit=12; pzwart=0; owit=0; ozwart=0; --nzwart;
             printf("1 V\n");// Let op, de vlag wordt geretourneerd, speler 2 moet zelf afsluiten!
             break;
    case  5: //zwart heeft een verkeerd stuk gegeven als antwoord
             strcpy(melding, "Blues_answer_illegal");
             sprintf(invoer, "\nRed wins because blue gave an illegal answer: %s %s %s\n\n", vertaalzet(2), vertaalstuk1(2), fout);
             pwit=12; pzwart=0; owit=0; ozwart=1;
             printf("1 X\n");
             break;
    case  2: //wit wint omdat zwart geen zetten meer heeft
             strcpy(melding, "Red_wins:_blue_cannot_move");
             sprintf(invoer, "\nRed wins because blue cannot move anymore\n\n");
             pwit=12; pzwart=0; owit=0; ozwart=0;
             if (witvlag) {printf("1 %s\n", vertaalstuk2(2)); witvlag=0;}
             break;
    case  3: //zwart heeft een illegale zet gedaan
             strcpy(melding, "Blue_move_illegal");
             sprintf(invoer, "\nBlue did an illegal move: %s\n\n", fout);
             pwit=12; pzwart=0; owit=0; ozwart=1;
             if (witvlag) {printf("1 %s\n", vertaalstuk2(2)); witvlag=0;}
             if (n!=200) printf("1 X\n");
             break;
    case  4: //zwart heeft een illegale zet gedaan als slazet
             strcpy(melding, "Blues_atacking_piece_is_ellegal");
             sprintf(invoer, "\nBlue's atacking piece was illegal: %s %s\n\n", vertaalzet(3), fout);
             pwit=12; pzwart=0; owit=0; ozwart=1;
             if (witvlag) {printf("1 %s\n", vertaalstuk2(2)); witvlag=0;}
             if (n!=200) printf("1 X\n");
             break;
    case -1: //zwart wint omdat de vlag gepakt is
             strcpy(melding, "Blue_wins:_gets_the_flag");
             sprintf(invoer, "blue  %2d: %s %s V\n\nBlue wins because he captures the red flag\n\n", n, vertaalzet(3), vertaalstuk1(3));
             pwit=0; pzwart=12; owit=0; ozwart=0; --nwit;
             printf("2 V\n");// Let op, de vlag wordt geretourneerd, speler 1 moet zelf afsluiten!
             break;
    case -5: //wit heeft een verkeerd stuk gegeven als antwoord
             strcpy(melding, "Reds_answer_illegal");
             sprintf(invoer, "\nBlue wins because red gave an illegal answer: %s %s %s\n\n", vertaalzet(3), vertaalstuk1(3), fout);
             pwit=0; pzwart=12; owit=1; ozwart=0;
             printf("2 X\n");
             break;
  }
  fflush(stdout);
  if (log)
  {
    fprintf(log, "%s", invoer);
    LOCK;
    printf("I request_time 1\n"); fflush(stdout);
    scanf("%s", invoer);
    if (strcmp(invoer, "time")) {fprintf(stderr, "Error by the caiaio\n"); exit(1);}
    scanf("%s", invoer);
    scanf("%s", fout);
    fprintf(log, "Red used in milliseconds:  %6s (%6s ms in real time)\n", fout, invoer);
    printf("I request_time 2\n"); fflush(stdout);
    scanf("%s", invoer);
    if (strcmp(invoer, "time")) {fprintf(stderr, "Error by the caiaio\n"); exit(1);}
    scanf("%s", invoer);
    scanf("%s", fout);
    fprintf(log, "Blue used in milliseconds: %6s (%6s ms in real time)\n\n", fout, invoer);
    UNLOCK;
    fprintf(log, "Manager report: %d-%d %d-%d %d-%d %d=%s\n", pwit, pzwart, nwit, nzwart, owit, ozwart, status, melding);
  }
  printf("M report %d %d %d %d %d %d %d %s\n", pwit, pzwart, nwit, nzwart, owit, ozwart, status, melding);
  fflush(stdout);
  return 0;
}

