/* Copyright (C) 2004 Marcel Vlastuin.

This file is part of the Caia project. This project can be
downloaded from the website www.codecup.nl. You can email to
marcel@vlastuin.net or write to Marcel Vlastuin, Perenstraat 40,
2564 SE Den Haag, The Netherlands.

*/

#include <stdio.h>
#include <stdlib.h>
#include <sys/time.h>

#define VLAG 1
#define BOM 2
#define GENERAAL 3
#define OVERSTE 4
#define LUITENANT 5
#define MONTEUR 6
#define RUITER 7
#define SPION 8

#define SCHUIF 0
#define SLA 1

#define MINOE -2000000
#define PLUSOE 2000000
#define WITWINST 1000000
#define ZWARTWINST -1000000

int a[47]=
{
  -36,-37,-38,-39,-40,-41,-42,  //  0  1  2  3  4  5  6
  -29,-30,-31,-32,-33,-34,-35,  //  7  8  9 10 11 12 13
  -22,-23,-24,-25,-26,-27,-28,  // 14 15 16 17 18 19 20
    0,      0,  0,  0,      0,  // 21 XX 22 23 24 XX 25
    1,  2,  3,  4,  5,  6,  7,  // 26 27 28 29 30 31 32
    8,  9, 10, 11, 12, 13, 14,  // 33 34 35 36 37 38 39
   15, 16, 17, 18, 19, 20, 21   // 40 41 42 43 44 45 46
};

int b[47][5]=
{
  { 1, 7,-1},            //  0
  { 0, 2, 8,-1},         //  1
  { 1, 3, 9,-1},         //  2
  { 2, 4,10,-1},         //  3
  { 3, 5,11,-1},         //  4
  { 4, 6,12,-1},         //  5
  { 5,13,-1},            //  6

  { 0, 8,14,-1},         //  7
  { 1, 7, 9,15,-1},      //  8
  { 2, 8,10,16,-1},      //  9
  { 3, 9,11,17,-1},      // 10
  { 4,10,12,18,-1},      // 11
  { 5,11,13,19,-1},      // 12
  { 6,12,20,-1},         // 13

  { 7,15,21,-1},         // 14
  { 8,14,16,-1},         // 15
  { 9,15,17,22,-1},      // 16
  {10,16,18,23,-1},      // 17
  {11,17,19,24,-1},      // 18
  {12,18,20,-1},         // 19
  {13,19,25,-1},         // 20

  {14,26,-1},            // 21
  {16,23,28,-1},         // 22
  {17,22,24,29,-1},      // 23
  {18,23,30,-1},         // 24
  {20,32,-1},            // 25
  
  {21,27,33,-1},         // 26
  {26,28,34,-1},         // 27
  {22,27,29,35,-1},      // 28
  {23,28,30,36,-1},      // 29
  {24,29,31,37,-1},      // 30
  {30,32,38,-1},         // 31
  {25,31,39,-1},         // 32

  {26,34,40,-1},         // 33
  {27,33,35,41,-1},      // 34
  {28,34,36,42,-1},      // 35
  {29,35,37,43,-1},      // 36
  {30,36,38,44,-1},      // 37
  {31,37,39,45,-1},      // 38
  {32,38,46,-1},         // 39

  {33,41,-1},            // 40
  {34,40,42,-1},         // 41
  {35,41,43,-1},         // 42
  {36,42,44,-1},         // 43
  {37,43,45,-1},         // 44
  {38,44,46,-1},         // 45
  {39,45,-1}             // 46
};

/*
int c[9][9]=
{
  {},
  {},                           // VLAG
  {},                           // BOM
  { 2,-1, 3, 4, 5, 6, 7, 8,-1}, // GENERAAL
  { 2, 3,-1, 4, 5, 6, 7, 8,-1}, // OVERSTE
  { 2, 3, 4,-1, 5, 6, 7, 8,-1}, // LUITENANT
  { 3, 4, 5,-1, 6, 2, 7, 8,-1}, // MONTEUR
  { 2, 3, 4, 5, 6,-1, 7, 8,-1}, // RUITER
  { 2, 4, 5, 6, 7,-1, 8, 3,-1}  // SPION
//{ 2, 3, 4, 5, 6, 7,-1, 8,-1}  // SPION
};
*/

const int afstand[47][47]=
{
  { 0, 1, 2, 3, 4, 5, 6, 1, 2, 3, 4, 5, 6, 7, 2, 3, 4, 5, 6, 7, 8, 3, 5, 6, 7, 9, 4, 5, 6, 7, 8, 9,10, 5, 6, 7, 8, 9,10,11, 6, 7, 8, 9,10,11,12},
  { 1, 0, 1, 2, 3, 4, 5, 2, 1, 2, 3, 4, 5, 6, 3, 2, 3, 4, 5, 6, 7, 4, 4, 5, 6, 8, 5, 6, 5, 6, 7, 8, 9, 6, 7, 6, 7, 8, 9,10, 7, 8, 7, 8, 9,10,11},
  { 2, 1, 0, 1, 2, 3, 4, 3, 2, 1, 2, 3, 4, 5, 4, 3, 2, 3, 4, 5, 6, 5, 3, 4, 5, 7, 6, 5, 4, 5, 6, 7, 8, 7, 6, 5, 6, 7, 8, 9, 8, 7, 6, 7, 8, 9,10},
  { 3, 2, 1, 0, 1, 2, 3, 4, 3, 2, 1, 2, 3, 4, 5, 4, 3, 2, 3, 4, 5, 6, 4, 3, 4, 6, 7, 6, 5, 4, 5, 6, 7, 8, 7, 6, 5, 6, 7, 8, 9, 8, 7, 6, 7, 8, 9},
  { 4, 3, 2, 1, 0, 1, 2, 5, 4, 3, 2, 1, 2, 3, 6, 5, 4, 3, 2, 3, 4, 7, 5, 4, 3, 5, 8, 7, 6, 5, 4, 5, 6, 9, 8, 7, 6, 5, 6, 7,10, 9, 8, 7, 6, 7, 8},
  { 5, 4, 3, 2, 1, 0, 1, 6, 5, 4, 3, 2, 1, 2, 7, 6, 5, 4, 3, 2, 3, 8, 6, 5, 4, 4, 9, 8, 7, 6, 5, 6, 5,10, 9, 8, 7, 6, 7, 6,11,10, 9, 8, 7, 8, 7},
  { 6, 5, 4, 3, 2, 1, 0, 7, 6, 5, 4, 3, 2, 1, 8, 7, 6, 5, 4, 3, 2, 9, 7, 6, 5, 3,10, 9, 8, 7, 6, 5, 4,11,10, 9, 8, 7, 6, 5,12,11,10, 9, 8, 7, 6},
  { 1, 2, 3, 4, 5, 6, 7, 0, 1, 2, 3, 4, 5, 6, 1, 2, 3, 4, 5, 6, 7, 2, 4, 5, 6, 8, 3, 4, 5, 6, 7, 8, 9, 4, 5, 6, 7, 8, 9,10, 5, 6, 7, 8, 9,10,11},
  { 2, 1, 2, 3, 4, 5, 6, 1, 0, 1, 2, 3, 4, 5, 2, 1, 2, 3, 4, 5, 6, 3, 3, 4, 5, 7, 4, 5, 4, 5, 6, 7, 8, 5, 6, 5, 6, 7, 8, 9, 6, 7, 6, 7, 8, 9,10},
  { 3, 2, 1, 2, 3, 4, 5, 2, 1, 0, 1, 2, 3, 4, 3, 2, 1, 2, 3, 4, 5, 4, 2, 3, 4, 6, 5, 4, 3, 4, 5, 6, 7, 6, 5, 4, 5, 6, 7, 8, 7, 6, 5, 6, 7, 8, 9},
  { 4, 3, 2, 1, 2, 3, 4, 3, 2, 1, 0, 1, 2, 3, 4, 3, 2, 1, 2, 3, 4, 5, 3, 2, 3, 5, 6, 5, 4, 3, 4, 5, 6, 7, 6, 5, 4, 5, 6, 7, 8, 7, 6, 5, 6, 7, 8},
  { 5, 4, 3, 2, 1, 2, 3, 4, 3, 2, 1, 0, 1, 2, 5, 4, 3, 2, 1, 2, 3, 6, 4, 3, 2, 4, 7, 6, 5, 4, 3, 4, 5, 8, 7, 6, 5, 4, 5, 6, 9, 8, 7, 6, 5, 6, 7},
  { 6, 5, 4, 3, 2, 1, 2, 5, 4, 3, 2, 1, 0, 1, 6, 5, 4, 3, 2, 1, 2, 7, 5, 4, 3, 3, 8, 7, 6, 5, 4, 5, 4, 9, 8, 7, 6, 5, 6, 5,10, 9, 8, 7, 6, 7, 6},
  { 7, 6, 5, 4, 3, 2, 1, 6, 5, 4, 3, 2, 1, 0, 7, 6, 5, 4, 3, 2, 1, 8, 6, 5, 4, 2, 9, 8, 7, 6, 5, 4, 3,10, 9, 8, 7, 6, 5, 4,11,10, 9, 8, 7, 6, 5},
  { 2, 3, 4, 5, 6, 7, 8, 1, 2, 3, 4, 5, 6, 7, 0, 1, 2, 3, 4, 5, 6, 1, 3, 4, 5, 7, 2, 3, 4, 5, 6, 7, 8, 3, 4, 5, 6, 7, 8, 9, 4, 5, 6, 7, 8, 9,10},
  { 3, 2, 3, 4, 5, 6, 7, 2, 1, 2, 3, 4, 5, 6, 1, 0, 1, 2, 3, 4, 5, 2, 2, 3, 4, 6, 3, 4, 3, 4, 5, 6, 7, 4, 5, 4, 5, 6, 7, 8, 5, 6, 5, 6, 7, 8, 9},
  { 4, 3, 2, 3, 4, 5, 6, 3, 2, 1, 2, 3, 4, 5, 2, 1, 0, 1, 2, 3, 4, 3, 1, 2, 3, 5, 4, 3, 2, 3, 4, 5, 6, 5, 4, 3, 4, 5, 6, 7, 6, 5, 4, 5, 6, 7, 8},
  { 5, 4, 3, 2, 3, 4, 5, 4, 3, 2, 1, 2, 3, 4, 3, 2, 1, 0, 1, 2, 3, 4, 2, 1, 2, 4, 5, 4, 3, 2, 3, 4, 5, 6, 5, 4, 3, 4, 5, 6, 7, 6, 5, 4, 5, 6, 7},
  { 6, 5, 4, 3, 2, 3, 4, 5, 4, 3, 2, 1, 2, 3, 4, 3, 2, 1, 0, 1, 2, 5, 3, 2, 1, 3, 6, 5, 4, 3, 2, 3, 4, 7, 6, 5, 4, 3, 4, 5, 8, 7, 6, 5, 4, 5, 6},
  { 7, 6, 5, 4, 3, 2, 3, 6, 5, 4, 3, 2, 1, 2, 5, 4, 3, 2, 1, 0, 1, 6, 4, 3, 2, 2, 7, 6, 5, 4, 3, 4, 3, 8, 7, 6, 5, 4, 5, 4, 9, 8, 7, 6, 5, 6, 5},
  { 8, 7, 6, 5, 4, 3, 2, 7, 6, 5, 4, 3, 2, 1, 6, 5, 4, 3, 2, 1, 0, 7, 5, 4, 3, 1, 8, 7, 6, 5, 4, 3, 2, 9, 8, 7, 6, 5, 4, 3,10, 9, 8, 7, 6, 5, 4},
  { 3, 4, 5, 6, 7, 8, 9, 2, 3, 4, 5, 6, 7, 8, 1, 2, 3, 4, 5, 6, 7, 0, 4, 5, 6, 8, 1, 2, 3, 4, 5, 6, 7, 2, 3, 4, 5, 6, 7, 8, 3, 4, 5, 6, 7, 8, 9},
  { 5, 4, 3, 4, 5, 6, 7, 4, 3, 2, 3, 4, 5, 6, 3, 2, 1, 2, 3, 4, 5, 4, 0, 1, 2, 6, 3, 2, 1, 2, 3, 4, 5, 4, 3, 2, 3, 4, 5, 6, 5, 4, 3, 4, 5, 6, 7},
  { 6, 5, 4, 3, 4, 5, 6, 5, 4, 3, 2, 3, 4, 5, 4, 3, 2, 1, 2, 3, 4, 5, 1, 0, 1, 5, 4, 3, 2, 1, 2, 3, 4, 5, 4, 3, 2, 3, 4, 5, 6, 5, 4, 3, 4, 5, 6},
  { 7, 6, 5, 4, 3, 4, 5, 6, 5, 4, 3, 2, 3, 4, 5, 4, 3, 2, 1, 2, 3, 6, 2, 1, 0, 4, 5, 4, 3, 2, 1, 2, 3, 6, 5, 4, 3, 2, 3, 4, 7, 6, 5, 4, 3, 4, 5},
  { 9, 8, 7, 6, 5, 4, 3, 8, 7, 6, 5, 4, 3, 2, 7, 6, 5, 4, 3, 2, 1, 8, 6, 5, 4, 0, 7, 6, 5, 4, 3, 2, 1, 8, 7, 6, 5, 4, 3, 2, 9, 8, 7, 6, 5, 4, 3},
  { 4, 5, 6, 7, 8, 9,10, 3, 4, 5, 6, 7, 8, 9, 2, 3, 4, 5, 6, 7, 8, 1, 3, 4, 5, 7, 0, 1, 2, 3, 4, 5, 6, 1, 2, 3, 4, 5, 6, 7, 2, 3, 4, 5, 6, 7, 8},
  { 5, 6, 5, 6, 7, 8, 9, 4, 5, 4, 5, 6, 7, 8, 3, 4, 3, 4, 5, 6, 7, 2, 2, 3, 4, 6, 1, 0, 1, 2, 3, 4, 5, 2, 1, 2, 3, 4, 5, 6, 3, 2, 3, 4, 5, 6, 7},
  { 6, 5, 4, 5, 6, 7, 8, 5, 4, 3, 4, 5, 6, 7, 4, 3, 2, 3, 4, 5, 6, 3, 1, 2, 3, 5, 2, 1, 0, 1, 2, 3, 4, 3, 2, 1, 2, 3, 4, 5, 4, 3, 2, 3, 4, 5, 6},
  { 7, 6, 5, 4, 5, 6, 7, 6, 5, 4, 3, 4, 5, 6, 5, 4, 3, 2, 3, 4, 5, 4, 2, 1, 2, 4, 3, 2, 1, 0, 1, 2, 3, 4, 3, 2, 1, 2, 3, 4, 5, 4, 3, 2, 3, 4, 5},
  { 8, 7, 6, 5, 4, 5, 6, 7, 6, 5, 4, 3, 4, 5, 6, 5, 4, 3, 2, 3, 4, 5, 3, 2, 1, 3, 4, 3, 2, 1, 0, 1, 2, 5, 4, 3, 2, 1, 2, 3, 6, 5, 4, 3, 2, 3, 4},
  { 9, 8, 7, 6, 5, 6, 5, 8, 7, 6, 5, 4, 5, 4, 7, 6, 5, 4, 3, 4, 3, 6, 4, 3, 2, 2, 5, 4, 3, 2, 1, 0, 1, 6, 5, 4, 3, 2, 1, 2, 7, 6, 5, 4, 3, 2, 3},
  {10, 9, 8, 7, 6, 5, 4, 9, 8, 7, 6, 5, 4, 3, 8, 7, 6, 5, 4, 3, 2, 7, 5, 4, 3, 1, 6, 5, 4, 3, 2, 1, 0, 7, 6, 5, 4, 3, 2, 1, 8, 7, 6, 5, 4, 3, 2},
  { 5, 6, 7, 8, 9,10,11, 4, 5, 6, 7, 8, 9,10, 3, 4, 5, 6, 7, 8, 9, 2, 4, 5, 6, 8, 1, 2, 3, 4, 5, 6, 7, 0, 1, 2, 3, 4, 5, 6, 1, 2, 3, 4, 5, 6, 7},
  { 6, 7, 6, 7, 8, 9,10, 5, 6, 5, 6, 7, 8, 9, 4, 5, 4, 5, 6, 7, 8, 3, 3, 4, 5, 7, 2, 1, 2, 3, 4, 5, 6, 1, 0, 1, 2, 3, 4, 5, 2, 1, 2, 3, 4, 5, 6},
  { 7, 6, 5, 6, 7, 8, 9, 6, 5, 4, 5, 6, 7, 8, 5, 4, 3, 4, 5, 6, 7, 4, 2, 3, 4, 6, 3, 2, 1, 2, 3, 4, 5, 2, 1, 0, 1, 2, 3, 4, 3, 2, 1, 2, 3, 4, 5},
  { 8, 7, 6, 5, 6, 7, 8, 7, 6, 5, 4, 5, 6, 7, 6, 5, 4, 3, 4, 5, 6, 5, 3, 2, 3, 5, 4, 3, 2, 1, 2, 3, 4, 3, 2, 1, 0, 1, 2, 3, 4, 3, 2, 1, 2, 3, 4},
  { 9, 8, 7, 6, 5, 6, 7, 8, 7, 6, 5, 4, 5, 6, 7, 6, 5, 4, 3, 4, 5, 6, 4, 3, 2, 4, 5, 4, 3, 2, 1, 2, 3, 4, 3, 2, 1, 0, 1, 2, 5, 4, 3, 2, 1, 2, 3},
  {10, 9, 8, 7, 6, 7, 6, 9, 8, 7, 6, 5, 6, 5, 8, 7, 6, 5, 4, 5, 4, 7, 5, 4, 3, 3, 6, 5, 4, 3, 2, 1, 2, 5, 4, 3, 2, 1, 0, 1, 6, 5, 4, 3, 2, 1, 2},
  {11,10, 9, 8, 7, 6, 5,10, 9, 8, 7, 6, 5, 4, 9, 8, 7, 6, 5, 4, 3, 8, 6, 5, 4, 2, 7, 6, 5, 4, 3, 2, 1, 6, 5, 4, 3, 2, 1, 0, 7, 6, 5, 4, 3, 2, 1},
  { 6, 7, 8, 9,10,11,12, 5, 6, 7, 8, 9,10,11, 4, 5, 6, 7, 8, 9,10, 3, 5, 6, 7, 9, 2, 3, 4, 5, 6, 7, 8, 1, 2, 3, 4, 5, 6, 7, 0, 1, 2, 3, 4, 5, 6},
  { 7, 8, 7, 8, 9,10,11, 6, 7, 6, 7, 8, 9,10, 5, 6, 5, 6, 7, 8, 9, 4, 4, 5, 6, 8, 3, 2, 3, 4, 5, 6, 7, 2, 1, 2, 3, 4, 5, 6, 1, 0, 1, 2, 3, 4, 5},
  { 8, 7, 6, 7, 8, 9,10, 7, 6, 5, 6, 7, 8, 9, 6, 5, 4, 5, 6, 7, 8, 5, 3, 4, 5, 7, 4, 3, 2, 3, 4, 5, 6, 3, 2, 1, 2, 3, 4, 5, 2, 1, 0, 1, 2, 3, 4},
  { 9, 8, 7, 6, 7, 8, 9, 8, 7, 6, 5, 6, 7, 8, 7, 6, 5, 4, 5, 6, 7, 6, 4, 3, 4, 6, 5, 4, 3, 2, 3, 4, 5, 4, 3, 2, 1, 2, 3, 4, 3, 2, 1, 0, 1, 2, 3},
  {10, 9, 8, 7, 6, 7, 8, 9, 8, 7, 6, 5, 6, 7, 8, 7, 6, 5, 4, 5, 6, 7, 5, 4, 3, 5, 6, 5, 4, 3, 2, 3, 4, 5, 4, 3, 2, 1, 2, 3, 4, 3, 2, 1, 0, 1, 2},
  {11,10, 9, 8, 7, 8, 7,10, 9, 8, 7, 6, 7, 6, 9, 8, 7, 6, 5, 6, 5, 8, 6, 5, 4, 4, 7, 6, 5, 4, 3, 2, 3, 6, 5, 4, 3, 2, 1, 2, 5, 4, 3, 2, 1, 0, 1},
  {12,11,10, 9, 8, 7, 6,11,10, 9, 8, 7, 6, 5,10, 9, 8, 7, 6, 5, 4, 9, 7, 6, 5, 3, 8, 7, 6, 5, 4, 3, 2, 7, 6, 5, 4, 3, 2, 1, 6, 5, 4, 3, 2, 1, 0}
};

int swit[9]={0,1,4,1,2,3,4,5,1};
int szwart[9]={0,1,4,1,2,3,4,5,1};
int sbekend[43];
int sstatus[43];
int overwit=16, overzwart=16;

int zet[1000][5]=
{
  {1, 33, 21},
  {1,  7, 21}
};
int pvul;

char hulp1(int x)
{
  switch(x)
  {
    case 0: return ' ';
    case 1: return 'V';
    case 2: return 'B';
    case 3: return 'G';
    case 4: return 'O';
    case 5: return 'L';
    case 6: return 'M';
    case 7: return 'R';
    case 8: return 'S';
  }
  return ' ';
}

char hulp2(int x)
{
  switch(x)
  {
    case 0: return ' ';
    case 1: return '!';
    case 2: return ' ';
  }
  return ' ';
}

void printbord(void)
{
  int i, h[43];
  printf("\n\n                 ");
  for (i=0; i<47; ++i)
  {
    if (i==22 || i==25) printf("  ##");    
    if (a[i]==0) printf("  .."); else printf(" %3d", a[i]);
    if (i==6 || i==13 || i==20 || i==25 || i==32 || i==39 || i==46) printf("\n\n                 ");
  }
  printf("\n       V  B  G  O  L  M  R  S          V  B  G  O  L  M  R  S \n");
  printf("  %3d", overwit);
  for (i=1; i<9; ++i) printf("%3d", swit[i]);
  printf("   ");
  printf("  %3d", overzwart);
  for (i=1; i<9; ++i) printf("%3d", szwart[i]);
  printf("\n\n       nn   bk bw                      nn   bk bw\n\n");
  for (i=1; i<43; ++i) h[i]=0;
  for (i=0; i<47; ++i) if (a[i]) h[abs(a[i])]=1;
  for (i=1; i<22; ++i)
  {
    if (h[i]) printf("      %3d    %c  %c", i, hulp1(sbekend[i]), hulp2(sstatus[i]));
    else printf("                 ");
    if (h[i+21]) printf("                     %3d    %c  %c\n", -i-21, hulp1(sbekend[i+21]), hulp2(sstatus[i+21]));
    else printf("\n");
  }
}

int doezetwit(int x, int *y, int *z)
{
  *y=a[zet[x][1]];
  *z=-a[zet[x][2]];
  if (zet[x][0]==SCHUIF)
  {
    a[zet[x][2]]=*y;
    a[zet[x][1]]=0;
    switch(sstatus[*y])
    {
      case 0: sstatus[*y]=1;
              --overwit;
              return 0;
      case 1: return 1;
      case 2: return 2;
    }
  }
  else
  {
    switch(10*zet[x][3]+zet[x][4])
    {
//    case 11: goto kanniet;
//    case 19: goto kanniet;

//    case 21: goto kanniet;
//    case 28: goto kanniet;

//    case 31: goto kanniet;
      case 32: goto bomwint;
      case 33: goto beide;
      case 34: goto aanvallerwint;
      case 35: goto aanvallerwint;
      case 36: goto aanvallerwint;
      case 37: goto aanvallerwint;
      case 38: goto aanvallerwint;

//    case 41: goto kanniet;
      case 42: goto bomwint;
      case 43: goto verdedigerwint;
      case 44: goto beide;
      case 45: goto aanvallerwint;
      case 46: goto aanvallerwint;
      case 47: goto aanvallerwint;
      case 48: goto aanvallerwint;

//    case 51: goto kanniet;
      case 52: goto bomwint;
      case 53: goto verdedigerwint;
      case 54: goto verdedigerwint;
      case 55: goto beide;
      case 56: goto aanvallerwint;
      case 57: goto aanvallerwint;
      case 58: goto aanvallerwint;

//    case 61: goto kanniet;
      case 62: goto bomverliest;
      case 63: goto verdedigerwint;
      case 64: goto verdedigerwint;
      case 65: goto verdedigerwint;
      case 66: goto beide;
      case 67: goto aanvallerwint;
      case 68: goto aanvallerwint;

//    case 71: goto kanniet;
      case 72: goto bomwint;
      case 73: goto verdedigerwint;
      case 74: goto verdedigerwint;
      case 75: goto verdedigerwint;
      case 76: goto verdedigerwint;
      case 77: goto beide;
      case 78: goto aanvallerwint;

//    case 81: goto kanniet;
      case 82: goto bomwint;
      case 83: goto aanvallerwint;
      case 84: goto verdedigerwint;
      case 85: goto verdedigerwint;
      case 86: goto verdedigerwint;
      case 87: goto verdedigerwint;
      case 88: goto beide;
    }
  
//kanniet:
    printf("Fout.1\n");
    exit(13);
    
beide:
    a[zet[x][1]]=0;
    a[zet[x][2]]=0;
    switch(10*sstatus[*y]+sstatus[*z])
    {
//    case  0: kanniet;
      case 10: --swit[zet[x][3]];
               --szwart[zet[x][4]];
               --overzwart;
               return 110;
      case 20: --szwart[zet[x][4]];
               --overzwart;
               return 120;
      case  1: --swit[zet[x][3]];
               --overwit;
               --szwart[zet[x][4]];
               return 101;
      case  2: --swit[zet[x][3]];
               --overwit;
               return 102;
      case 11: --swit[zet[x][3]];
               --szwart[zet[x][4]];
               return 111;
      case 21: --szwart[zet[x][4]];
               return 121;
      case 12: --swit[zet[x][3]];
               return 112;
      case 22: return 122;
    }
    
aanvallerwint:
    a[zet[x][1]]=0;
    a[zet[x][2]]=*y;
    switch(10*sstatus[*y]+sstatus[*z])
    {
//    case  0: kanniet;
      case 10: --swit[sbekend[*y]=zet[x][3]];
               sstatus[*y]=2;
               --szwart[zet[x][4]];
               --overzwart;
               return 210;
      case 20: --szwart[zet[x][4]];
               --overzwart;
               return 220;
      case  1: --swit[sbekend[*y]=zet[x][3]];
               sstatus[*y]=2;
               --overwit;
               --szwart[zet[x][4]];
               return 201;
      case  2: --swit[sbekend[*y]=zet[x][3]];
               sstatus[*y]=2;
               --overwit;
               return 202;
      case 11: --swit[sbekend[*y]=zet[x][3]];
               sstatus[*y]=2;
               --szwart[zet[x][4]];
               return 211;
      case 21: --szwart[zet[x][4]];
               return 221;
      case 12: --swit[sbekend[*y]=zet[x][3]];
               sstatus[*y]=2;
               return 212;
      case 22: return 222;
    }
    
verdedigerwint:
    a[zet[x][1]]=0;
    switch(10*sstatus[*y]+sstatus[*z])
    {
//    case  0: kanniet;
      case 10: --swit[zet[x][3]];
               --szwart[sbekend[*z]=zet[x][4]];
               sstatus[*z]=2;
               --overzwart;
               return 310;
      case 20: --szwart[sbekend[*z]=zet[x][4]];
               sstatus[*z]=2;
               --overzwart;
               return 320;
      case  1: --swit[zet[x][3]];
               --overwit;
               --szwart[sbekend[*z]=zet[x][4]];
               sstatus[*z]=2;
               return 301;
      case  2: --swit[zet[x][3]];
               --overwit;
               return 302;
      case 11: --swit[zet[x][3]];
               --szwart[sbekend[*z]=zet[x][4]];
               sstatus[*z]=2;
               return 311;
      case 21: --szwart[sbekend[*z]=zet[x][4]];
               sstatus[*z]=2;
               return 321;
      case 12: --swit[zet[x][3]];
               return 312;
      case 22: return 322;
    }

bomwint:
    a[zet[x][1]]=0;
    switch(10*sstatus[*y]+sstatus[*z])
    {
//    case  0: kanniet;
      case 10: --swit[zet[x][3]];
               --szwart[sbekend[*z]=BOM];
               sstatus[*z]=2;
               return 410;
      case 20: --szwart[sbekend[*z]=BOM];
               sstatus[*z]=2;
               return 420;
//    case  1: kanniet;
//    case  2: kanniet;
//    case 11: kanniet;
//    case 21: kanniet;
      case 12: --swit[zet[x][3]];
               return 412;
      case 22: return 422;
    }

bomverliest:
    a[zet[x][1]]=0;
    a[zet[x][2]]=*y;
    switch(10*sstatus[*y]+sstatus[*z])
    {
//    case  0: kanniet;
      case 10: --swit[sbekend[*y]=MONTEUR];
               sstatus[*y]=2;
               --szwart[BOM];
               return 510;
      case 20: --szwart[BOM];
               return 520;
//    case  1: kanniet;
//    case  2: kanniet;
//    case 11: kanniet;
//    case 21: kanniet;
      case 12: --swit[sbekend[*y]=MONTEUR];
               sstatus[*y]=2;
               return 512;
      case 22: return 522;
    }
  }
  return 13;
}

void herstelzetwit(int x, int y, int z, int status)
{
  a[zet[x][1]]=y;
  a[zet[x][2]]=-z;
  if (zet[x][0]==SCHUIF)
  {
    switch(status)
    {
      case 0: sstatus[y]=0;
              ++overwit;
              return;
      case 1: sstatus[y]=1;
              return;
      case 2: sstatus[y]=2;
              return;
    }
  }
  else
  {
    switch(status)
    {
//beide:
      case 110: ++swit[zet[x][3]];
                ++szwart[zet[x][4]];
                ++overzwart;
                return;
      case 120: ++szwart[zet[x][4]];
                ++overzwart;
                return;
      case 101: ++swit[zet[x][3]];
                ++overwit;
                ++szwart[zet[x][4]];
                return;
      case 102: ++swit[zet[x][3]];
                ++overwit;
                return;
      case 111: ++swit[zet[x][3]];
                ++szwart[zet[x][4]];
                return;
      case 121: ++szwart[zet[x][4]];
                return;
      case 112: ++swit[zet[x][3]];
                return;
      case 122: return;
      
//aanvallerwint:
      case 210: ++swit[zet[x][3]];
                sbekend[y]=0;
                sstatus[y]=1;
                ++szwart[zet[x][4]];
                ++overzwart;
                return;
      case 220: ++szwart[zet[x][4]];
                ++overzwart;
                return;
      case 201: ++swit[zet[x][3]];
                sbekend[y]=0;
                sstatus[y]=0;
                ++overwit;
                ++szwart[zet[x][4]];
                return;
      case 202: ++swit[zet[x][3]];
                sbekend[y]=0;
                sstatus[y]=0;
                ++overwit;
                return;
      case 211: ++swit[zet[x][3]];
                sbekend[y]=0;
                sstatus[y]=1;
                ++szwart[zet[x][4]];
                return;
      case 221: ++szwart[zet[x][4]];
                return;
      case 212: ++swit[zet[x][3]];
                sbekend[y]=0;
                sstatus[y]=1;
                return;
      case 222: return;

//verdedigerwint:
      case 310: ++swit[zet[x][3]];
                ++szwart[zet[x][4]];
                sbekend[z]=0;
                sstatus[z]=0;
                ++overzwart;
                return;
      case 320: ++szwart[zet[x][4]];
                sbekend[z]=0;
                sstatus[z]=0;
                ++overzwart;
                return;
      case 301: ++swit[zet[x][3]];
                ++overwit;
                ++szwart[zet[x][4]];
                sbekend[z]=0;
                sstatus[z]=1;
                return;
      case 302: ++swit[zet[x][3]];
                ++overwit;
                return;
      case 311: ++swit[zet[x][3]];
                ++szwart[zet[x][4]];
                sbekend[z]=0;
                sstatus[z]=1;
                return;
      case 321: ++szwart[zet[x][4]];
                sbekend[z]=0;
                sstatus[z]=1;
                return;
      case 312: ++swit[zet[x][3]];
                return;
      case 322: return;

//bomwint:
      case 410: ++swit[zet[x][3]];
                ++szwart[BOM];
                sbekend[z]=0;
                sstatus[z]=0;
                return;
      case 420: ++szwart[BOM];
                sbekend[z]=0;
                sstatus[z]=0;
                return;
      case 412: ++swit[zet[x][3]];
                return;
      case 422: return;
      
//bomverliest:
      case 510: ++swit[MONTEUR];
                sbekend[y]=0;
                sstatus[y]=1;
                ++szwart[BOM];
                return;
      case 520: ++szwart[BOM];
                return;
      case 512: ++swit[MONTEUR];
                sbekend[y]=0;
                sstatus[y]=1;
                return;
      case 522: return;
    }
  }
}

int doezetzwart(int x, int *y, int *z)
{
  *y=-a[zet[x][1]];
  *z=a[zet[x][2]];
  if (zet[x][0]==SCHUIF)
  {
    a[zet[x][2]]=-*y;
    a[zet[x][1]]=0;
    switch(sstatus[*y])
    {
      case 0: sstatus[*y]=1;
              --overzwart;
              return 0;
      case 1: return 1;
      case 2: return 2;
    }
  }
  else
  {
    switch(10*zet[x][3]+zet[x][4])
    {
//    case 11: goto kanniet;
//    case 19: goto kanniet;

//    case 21: goto kanniet;
//    case 28: goto kanniet;

//    case 31: goto kanniet;
      case 32: goto bomwint;
      case 33: goto beide;
      case 34: goto aanvallerwint;
      case 35: goto aanvallerwint;
      case 36: goto aanvallerwint;
      case 37: goto aanvallerwint;
      case 38: goto aanvallerwint;

//    case 41: goto kanniet;
      case 42: goto bomwint;
      case 43: goto verdedigerwint;
      case 44: goto beide;
      case 45: goto aanvallerwint;
      case 46: goto aanvallerwint;
      case 47: goto aanvallerwint;
      case 48: goto aanvallerwint;

//    case 51: goto kanniet;
      case 52: goto bomwint;
      case 53: goto verdedigerwint;
      case 54: goto verdedigerwint;
      case 55: goto beide;
      case 56: goto aanvallerwint;
      case 57: goto aanvallerwint;
      case 58: goto aanvallerwint;

//    case 61: goto kanniet;
      case 62: goto bomverliest;
      case 63: goto verdedigerwint;
      case 64: goto verdedigerwint;
      case 65: goto verdedigerwint;
      case 66: goto beide;
      case 67: goto aanvallerwint;
      case 68: goto aanvallerwint;

//    case 71: goto kanniet;
      case 72: goto bomwint;
      case 73: goto verdedigerwint;
      case 74: goto verdedigerwint;
      case 75: goto verdedigerwint;
      case 76: goto verdedigerwint;
      case 77: goto beide;
      case 78: goto aanvallerwint;

//    case 81: goto kanniet;
      case 82: goto bomwint;
      case 83: goto aanvallerwint;
      case 84: goto verdedigerwint;
      case 85: goto verdedigerwint;
      case 86: goto verdedigerwint;
      case 87: goto verdedigerwint;
      case 88: goto beide;
    }
  
//kanniet:
    printf("Fout.2 %d\n", 10*zet[x][3]+zet[x][4]);
    exit(13);
    
beide:
    a[zet[x][1]]=0;
    a[zet[x][2]]=0;
    switch(10*sstatus[*y]+sstatus[*z])
    {
//    case  0: kanniet;
      case 10: --szwart[zet[x][3]];
               --swit[zet[x][4]];
               --overwit;
               return 110;
      case 20: --swit[zet[x][4]];
               --overwit;
               return 120;
      case  1: --szwart[zet[x][3]];
               --overzwart;
               --swit[zet[x][4]];
               return 101;
      case  2: --szwart[zet[x][3]];
               --overzwart;
               return 102;
      case 11: --szwart[zet[x][3]];
               --swit[zet[x][4]];
               return 111;
      case 21: --swit[zet[x][4]];
               return 121;
      case 12: --szwart[zet[x][3]];
               return 112;
      case 22: return 122;
    }
    
aanvallerwint:
    a[zet[x][1]]=0;
    a[zet[x][2]]=-*y;
    switch(10*sstatus[*y]+sstatus[*z])
    {
//    case  0: kanniet;
      case 10: --szwart[sbekend[*y]=zet[x][3]];
               sstatus[*y]=2;
               --swit[zet[x][4]];
               --overwit;
               return 210;
      case 20: --swit[zet[x][4]];
               --overwit;
               return 220;
      case  1: --szwart[sbekend[*y]=zet[x][3]];
               sstatus[*y]=2;
               --overzwart;
               --swit[zet[x][4]];
               return 201;
      case  2: --szwart[sbekend[*y]=zet[x][3]];
               sstatus[*y]=2;
               --overzwart;
               return 202;
      case 11: --szwart[sbekend[*y]=zet[x][3]];
               sstatus[*y]=2;
               --swit[zet[x][4]];
               return 211;
      case 21: --swit[zet[x][4]];
               return 221;
      case 12: --szwart[sbekend[*y]=zet[x][3]];
               sstatus[*y]=2;
               return 212;
      case 22: return 222;
    }
    
verdedigerwint:
    a[zet[x][1]]=0;
    switch(10*sstatus[*y]+sstatus[*z])
    {
//    case  0: kanniet;
      case 10: --szwart[zet[x][3]];
               --swit[sbekend[*z]=zet[x][4]];
               sstatus[*z]=2;
               --overwit;
               return 310;
      case 20: --swit[sbekend[*z]=zet[x][4]];
               sstatus[*z]=2;
               --overwit;
               return 320;
      case  1: --szwart[zet[x][3]];
               --overzwart;
               --swit[sbekend[*z]=zet[x][4]];
               sstatus[*z]=2;
               return 301;
      case  2: --szwart[zet[x][3]];
               --overzwart;
               return 302;
      case 11: --szwart[zet[x][3]];
               --swit[sbekend[*z]=zet[x][4]];
               sstatus[*z]=2;
               return 311;
      case 21: --swit[sbekend[*z]=zet[x][4]];
               sstatus[*z]=2;
               return 321;
      case 12: --szwart[zet[x][3]];
               return 312;
      case 22: return 322;
    }

bomwint:
    a[zet[x][1]]=0;
    switch(10*sstatus[*y]+sstatus[*z])
    {
//    case  0: kanniet;
      case 10: --szwart[zet[x][3]];
               --swit[sbekend[*z]=BOM];
               sstatus[*z]=2;
               return 410;
      case 20: --swit[sbekend[*z]=BOM];
               sstatus[*z]=2;
               return 420;
//    case  1: kanniet;
//    case  2: kanniet;
//    case 11: kanniet;
//    case 21: kanniet;
      case 12: --szwart[zet[x][3]];
               return 412;
      case 22: return 422;
    }

bomverliest:
    a[zet[x][1]]=0;
    a[zet[x][2]]=-*y;
    switch(10*sstatus[*y]+sstatus[*z])
    {
//    case  0: kanniet;
      case 10: --szwart[sbekend[*y]=MONTEUR];
               sstatus[*y]=2;
               --swit[BOM];
               return 510;
      case 20: --swit[BOM];
               return 520;
//    case  1: kanniet;
//    case  2: kanniet;
//    case 11: kanniet;
//    case 21: kanniet;
      case 12: --szwart[sbekend[*y]=MONTEUR];
               sstatus[*y]=2;
               return 512;
      case 22: return 522;
    }
  }
  return 13;
}

void herstelzetzwart(int x, int y, int z, int status)
{
  a[zet[x][1]]=-y;
  a[zet[x][2]]=z;
  if (zet[x][0]==SCHUIF)
  {
    switch(status)
    {
      case 0: sstatus[y]=0;
              ++overzwart;
              return;
      case 1: sstatus[y]=1;
              return;
      case 2: sstatus[y]=2;
              return;
    }
  }
  else
  {
    switch(status)
    {
//beide:
      case 110: ++szwart[zet[x][3]];
                ++swit[zet[x][4]];
                ++overwit;
                return;
      case 120: ++swit[zet[x][4]];
                ++overwit;
                return;
      case 101: ++szwart[zet[x][3]];
                ++overzwart;
                ++swit[zet[x][4]];
                return;
      case 102: ++szwart[zet[x][3]];
                ++overzwart;
                return;
      case 111: ++szwart[zet[x][3]];
                ++swit[zet[x][4]];
                return;
      case 121: ++swit[zet[x][4]];
                return;
      case 112: ++szwart[zet[x][3]];
                return;
      case 122: return;
      
//aanvallerwint:
      case 210: ++szwart[zet[x][3]];
                sbekend[y]=0;
                sstatus[y]=1;
                ++swit[zet[x][4]];
                ++overwit;
                return;
      case 220: ++swit[zet[x][4]];
                ++overwit;
                return;
      case 201: ++szwart[zet[x][3]];
                sbekend[y]=0;
                sstatus[y]=0;
                ++overzwart;
                ++swit[zet[x][4]];
                return;
      case 202: ++szwart[zet[x][3]];
                sbekend[y]=0;
                sstatus[y]=0;
                ++overzwart;
                return;
      case 211: ++szwart[zet[x][3]];
                sbekend[y]=0;
                sstatus[y]=1;
                ++swit[zet[x][4]];
                return;
      case 221: ++swit[zet[x][4]];
                return;
      case 212: ++szwart[zet[x][3]];
                sbekend[y]=0;
                sstatus[y]=1;
                return;
      case 222: return;

//verdedigerwint:
      case 310: ++szwart[zet[x][3]];
                ++swit[zet[x][4]];
                sbekend[z]=0;
                sstatus[z]=0;
                ++overwit;
                return;
      case 320: ++swit[zet[x][4]];
                sbekend[z]=0;
                sstatus[z]=0;
                ++overwit;
                return;
      case 301: ++szwart[zet[x][3]];
                ++overzwart;
                ++swit[zet[x][4]];
                sbekend[z]=0;
                sstatus[z]=1;
                return;
      case 302: ++szwart[zet[x][3]];
                ++overzwart;
                return;
      case 311: ++szwart[zet[x][3]];
                ++swit[zet[x][4]];
                sbekend[z]=0;
                sstatus[z]=1;
                return;
      case 321: ++swit[zet[x][4]];
                sbekend[z]=0;
                sstatus[z]=1;
                return;
      case 312: ++szwart[zet[x][3]];
                return;
      case 322: return;

//bomwint:
      case 410: ++szwart[zet[x][3]];
                ++swit[BOM];
                sbekend[z]=0;
                sstatus[z]=0;
                return;
      case 420: ++swit[BOM];
                sbekend[z]=0;
                sstatus[z]=0;
                return;
      case 412: ++szwart[zet[x][3]];
                return;
      case 422: return;
      
//bomverliest:
      case 510: ++szwart[MONTEUR];
                sbekend[y]=0;
                sstatus[y]=1;
                ++swit[BOM];
                return;
      case 520: ++swit[BOM];
                return;
      case 512: ++szwart[MONTEUR];
                sbekend[y]=0;
                sstatus[y]=1;
                return;
      case 522: return;
    }
  }
}

void zoekzetwit(int his)
{
  int i, j, k, h1=zet[his][0], h2=zet[his][1], h3=zet[his][2];
  for (i=0; i<47; ++i)
  {
    if (a[i]<=0) continue;
    if (sbekend[a[i]]==BOM) continue;
    if (!overwit && !sstatus[a[i]]) continue;
    j=0;
    do
    {
      if (!a[b[i][j]])
      {
        if (h1==SCHUIF && h2==b[i][j] && h3==i) continue;
        zet[pvul][0]=SCHUIF;
        zet[pvul][1]=i;
        zet[pvul++][2]=b[i][j];
      }
      else if (a[b[i][j]]<0)
      {
        if (sbekend[a[i]])
        {
          zet[pvul][0]=SLA;
          zet[pvul][1]=i;
          zet[pvul][2]=b[i][j];
          zet[pvul++][3]=sbekend[a[i]];
        }
        else
        {
          for (k=3; k<9; ++k)
          {
            if (swit[k])
            {
              zet[pvul][0]=SLA;
              zet[pvul][1]=i;
              zet[pvul][2]=b[i][j];
              zet[pvul++][3]=k;
            }
          }
        }
      }
    } while (b[i][++j]!=-1);
  }
}

void zoekzetzwart(int his)
{
  int i, j, k, h1=zet[his][0], h2=zet[his][1], h3=zet[his][2];
  for (i=0; i<47; ++i)
  {
    if (a[i]>=0) continue;
    if (sbekend[-a[i]]==BOM) continue;
    if (!overzwart && !sstatus[-a[i]]) continue;
    j=0;
    do
    {
      if (!a[b[i][j]])
      {
        if (h1==SCHUIF && h2==b[i][j] && h3==i) continue;
        zet[pvul][0]=SCHUIF;
        zet[pvul][1]=i;
        zet[pvul++][2]=b[i][j];
      }
      else if (a[b[i][j]]>0)
      {
        if (sbekend[-a[i]])
        {
          zet[pvul][0]=SLA;
          zet[pvul][1]=i;
          zet[pvul][2]=b[i][j];
          zet[pvul++][3]=sbekend[-a[i]];
        }
        else
        {
          for (k=3; k<9; ++k)
          {
            if (szwart[k])
            {
              zet[pvul][0]=SLA;
              zet[pvul][1]=i;
              zet[pvul][2]=b[i][j];
              zet[pvul++][3]=k;
            }
          }
        }
      }
    } while (b[i][++j]!=-1);
  }
}

int analysewit(int, int, int, int, int, long, long *);
int analysezwart(int, int, int, int, int, long , long *);
void berekenwit(int, int, int, long, long *);
void berekenzwart(int, int, int, long, long *);

long tijdber=50000, tijdoverber=19500000;

int berekenzetwit(int n, int his1, int his2)
{
  int i, grootste=MINOE, z=0;
  long rt, t, factor;
  struct timeval start, stop;
  pvul=2;
  gettimeofday(&start, NULL);
  zoekzetwit(his1);
  if (pvul==2) {printf("Fout.3\n"); exit(0);}
  if (n<100) berekenwit(0, 0, his2, tijdber, &rt);
  else berekenwit((n-100)/2, 0, his2, tijdber, &rt);
  for (i=2; i<pvul; ++i) if (zet[i][4]>grootste) {grootste=zet[i][4]; z=i;}
  gettimeofday(&stop, NULL);
  
  t=1000000*(stop.tv_sec-start.tv_sec)+stop.tv_usec-start.tv_usec;
  tijdoverber-=t;
  factor=1000*(tijdber-rt)/t;
  if (t>5000) tijdber=factor*(tijdoverber/(201-n)/1000);
  if (tijdber>1000000 || tijdber<1000) tijdber=50000;
  fprintf(stderr, "tijdber=%ld\n", tijdber); fflush(stderr);

  return z;
}

int berekenzetzwart(int n, int his1, int his2)
{
  int i, kleinste=PLUSOE, z=0;
  long t, rt, factor;
  struct timeval start, stop;
  pvul=2;
  gettimeofday(&start, NULL);
  zoekzetzwart(his1);
  if (pvul==2) {printf("Fout.4\n"); exit(0);}
  if (n<100) berekenzwart(0, 0, his2, tijdber, &rt);
  else berekenzwart((n-100)/2, 0, his2, tijdber, &rt);
  for (i=2; i<pvul; ++i) if (zet[i][4]<kleinste) {kleinste=zet[i][4]; z=i;}
  gettimeofday(&stop, NULL);
  
  t=1000000*(stop.tv_sec-start.tv_sec)+stop.tv_usec-start.tv_usec;
  tijdoverber-=t;
  factor=1000*(tijdber-rt)/t;
  if (t>5000) tijdber=factor*(tijdoverber/(201-n)/1000);
  if (tijdber>1000000 || tijdber<1000) tijdber=50000;
  fprintf(stderr, "tijdber=%ld\n", tijdber); fflush(stderr);
  
  return z;
}

const int punt[5][8]=
{
  {     0,  8000,  9900,  9988,  9994,  9997,  9999, 10000},
  {   -30,   100,   900,   988,   994,   997,   999,  1000},
  {  -100,   -10,   100,    88,    94,    97,    99,   100},
  {  -300,   -30,   -10,    -5,     4,     7,     9,    10},
  { -1000,  -100,   -50,   -12,    -7,    -3,    -1,     0}
};

int telwit2(int x, int y)
{
  int t=0;
  if (a[x]<=0) return 0;
  if (sstatus[a[x]]==1) return 0;
  if (sbekend[a[x]] && sbekend[a[x]]!=BOM) return 0;
  if (sstatus[a[x]]==0) ++t;
  if (a[y]<=0) return 0;
  if (sstatus[a[y]]==1) return 0;
  if (sbekend[a[y]] && sbekend[a[y]]!=BOM) return 0;
  if (sstatus[a[y]]==0) ++t;
  if (swit[2]>=t) return 1;
  return 0;
}

int telwit3(int x, int y, int z)
{
  int t=0;
  if (a[x]<=0) return 0;
  if (sstatus[a[x]]==1) return 0;
  if (sbekend[a[x]] && sbekend[a[x]]!=BOM) return 0;
  if (sstatus[a[x]]==0) ++t;
  if (a[y]<=0) return 0;
  if (sstatus[a[y]]==1) return 0;
  if (sbekend[a[y]] && sbekend[a[y]]!=BOM) return 0;
  if (sstatus[a[y]]==0) ++t;
  if (a[z]<=0) return 0;
  if (sstatus[a[z]]==1) return 0;
  if (sbekend[a[z]] && sbekend[a[z]]!=BOM) return 0;
  if (sstatus[a[z]]==0) ++t;
  if (swit[2]>=t) return 1;
  return 0;
}

int telzwart2(int x, int y)
{
  int t=0;
  if (a[x]>=0) return 0;
  if (sstatus[-a[x]]==1) return 0;
  if (sbekend[-a[x]] && sbekend[-a[x]]!=BOM) return 0;
  if (sstatus[-a[x]]==0) ++t;
  if (a[y]>=0) return 0;
  if (sstatus[-a[y]]==1) return 0;
  if (sbekend[-a[y]] && sbekend[-a[y]]!=BOM) return 0;
  if (sstatus[-a[y]]==0) ++t;
  if (szwart[2]>=t) return 1;
  return 0;
}

int telzwart3(int x, int y, int z)
{
  int t=0;
  if (a[x]>=0) return 0;
  if (sstatus[-a[x]]==1) return 0;
  if (sbekend[-a[x]] && sbekend[-a[x]]!=BOM) return 0;
  if (sstatus[-a[x]]==0) ++t;
  if (a[y]>=0) return 0;
  if (sstatus[-a[y]]==1) return 0;
  if (sbekend[-a[y]] && sbekend[-a[y]]!=BOM) return 0;
  if (sstatus[-a[y]]==0) ++t;
  if (a[z]>=0) return 0;
  if (sstatus[-a[z]]==1) return 0;
  if (sbekend[-a[z]] && sbekend[-a[z]]!=BOM) return 0;
  if (sstatus[-a[z]]==0) ++t;
  if (szwart[2]>=t) return 1;
  return 0;
}

int telafstandwit(int i)
{
  int j, som=0;
  for (j=0; j<47; ++j) if (a[j]<0) som+=afstand[i][j];
  return som;
}

int telafstandzwart(int i)
{
  int j, som=0;
  for (j=0; j<47; ++j) if (a[j]>0) som+=afstand[i][j];
  return som;
}

int nn, kleur;

int punttel(void)
{
  int i, p=0, nw[9], nz[9];//, telw=0, telz=0;
  for (i=2; i<9; ++i) {nw[i]=0; nz[i]=0;}

  for (i=0; i<47; ++i)
  {
    if (a[i]>0) if (sbekend[a[i]]) ++nw[sbekend[a[i]]];
    if (a[i]<0) if (sbekend[-a[i]]) ++nz[sbekend[-a[i]]];
  }
  if (nn<100) 
  {
    p+=1000*swit[2]+400*nw[2];
    p+=(3000+kleur)*swit[3]+(1750+kleur)*nw[3];
    p+=2000*swit[4]+1250*nw[4];
    p+=1000*swit[5]+800*nw[5];
    p+=1000*swit[6]+400*nw[6];
    p+=400*swit[7]+300*nw[7];
    if (szwart[3]+nz[3]) p+=1250*swit[8]+200*nw[8]; else p+=100*(swit[8]+nw[8]);

    p-=1000*szwart[2]+400*nz[2];
    p-=(3000-kleur)*szwart[3]+(1750-kleur)*nz[3];
    p-=2000*szwart[4]+1250*nz[4];
    p-=1000*szwart[5]+800*nz[5];
    p-=1000*szwart[6]+400*nz[6];
    p-=400*szwart[7]+300*nz[7];
    if (swit[3]+nw[3]) p-=1250*szwart[8]+200*nz[8]; else p-=100*(szwart[8]+nz[8]);
  }
  else
  {  
    p+=1000*swit[2]+400*nw[2];
    p+=2750*swit[3]+1750*nw[3];
    p+=1750*swit[4]+1250*nw[4];
    p+=1250*swit[5]+1000*nw[5];
    p+=1000*swit[6]+400*nw[6];
    p+=400*swit[7]+300*nw[7];
    if (szwart[3]+nz[3]) p+=750*swit[8]+200*nw[8]; else p+=100*(swit[8]+nw[8]);

    p-=1000*szwart[2]+400*nz[2];
    p-=2750*szwart[3]+1750*nz[3];
    p-=1750*szwart[4]+1250*nz[4];
    p-=1250*szwart[5]+1000*nz[5];
    p-=1000*szwart[6]+400*nz[6];
    p-=400*szwart[7]+300*nz[7];
    if (swit[3]+nw[3]) p-=750*szwart[8]+200*nz[8]; else p-=100*(szwart[8]+nz[8]);
  }

/*
  if (telwit2(33, 41)) ++telw;
  if (telwit2(39, 45)) ++telw;
  if (telwit3(40, 34, 42)) ++telw;
  if (telwit3(41, 35, 43)) ++telw;
  if (telwit3(42, 36, 44)) ++telw;
  if (telwit3(43, 37, 45)) ++telw;
  if (telwit3(44, 38, 46)) ++telw;
  if (telzwart2(1, 7)) ++telz;
  if (telzwart2(5, 13)) ++telz;
  if (telzwart3(0, 8, 2)) ++telz;
  if (telzwart3(1, 9, 3)) ++telz;
  if (telzwart3(2, 10, 4)) ++telz;
  if (telzwart3(3, 11, 5)) ++telz;
  if (telzwart3(4, 12, 6)) ++telz;

//  return p + telafstand();*/
  return p + 200*(overwit-overzwart); // + punt[szwart[6]+nz[6]][telw] - punt[swit[6]+nw[6]][telz];
}

void berekenwit(int n, int niv, int his2, long tijd, long *rt)
{
  int i, j, k, grootste=MINOE, st, h1, h2, u, som, tel, aantal=0, ii;
  long time;
    
  for (i=2; i<pvul; ++i)
  {
    if (zet[i][0]==SCHUIF)
    {
      ++aantal;
    }
    else if (sbekend[-a[zet[i][2]]])
    {
      ++aantal;
    }
    else
    {
      k=0;
      if (sbekend[a[zet[i][1]]])
      {
        for (j=2; j<9; ++j)
        {
          if (j==2 && sstatus[-a[zet[i][2]]]==1) continue;
          if (j!=2 && !overzwart && !sstatus[-a[zet[i][2]]]) continue;
          if (szwart[j])
          {
            ++k; ++aantal;
          }
        }
      }
      else
      {
        for (j=2; j<8; ++j)
        {
          if (j==2 && sstatus[-a[zet[i][2]]]==1) continue;
          if (j!=2 && !overzwart && !sstatus[-a[zet[i][2]]]) continue;
          if (szwart[j])
          {
            ++k; ++aantal;
          }
        }
        if (k==0 && szwart[SPION] && (overzwart || sstatus[-a[zet[i][2]]]))
        {
          ++k; ++aantal;
        }
      }
      if (k==0) {continue;}
    }
  }
    
  ii=0;  
  for (i=2; i<pvul; ++i)
  {
    tel=n*(telafstandwit(zet[i][1])-telafstandwit(zet[i][2]));
    if (zet[i][0]==SCHUIF)
    {
      st=doezetwit(i, &h1, &h2);
      time=tijd/(aantal-ii++);
      u=analysezwart(niv+1, his2, i, MINOE, PLUSOE, time, rt)+tel;
      tijd+=*rt-time;
      if (u>grootste) grootste=u;
      herstelzetwit(i, h1, h2, st);
    }
    else if (sbekend[-a[zet[i][2]]])
    {
      zet[i][4]=sbekend[-a[zet[i][2]]];
      st=doezetwit(i, &h1, &h2);
      time=tijd/(aantal-ii++);
      u=analysezwart(niv+1, his2, i, MINOE, PLUSOE, time, rt)+tel;
      tijd+=*rt-time;
      if (u>grootste) grootste=u;
      herstelzetwit(i, h1, h2, st);
    }
    else
    {
      k=0; som=0;
      if (sbekend[a[zet[i][1]]])
      {
        som=PLUSOE;
        for (j=2; j<9; ++j)
        {
          if (j==2 && sstatus[-a[zet[i][2]]]==1) continue;
          if (j!=2 && !overzwart && !sstatus[-a[zet[i][2]]]) continue;
          if (szwart[j])
          {
            zet[i][4]=j;
            ++k;
            st=doezetwit(i, &h1, &h2);
            time=tijd/(aantal-ii++);
            u=analysezwart(niv+1, his2, i, MINOE, PLUSOE, time, rt)+tel;
            if (u<som) som=u;
            tijd+=*rt-time;
            herstelzetwit(i, h1, h2, st);
          }
        }
        if (k) k=1;
      }
      else
      {
        for (j=2; j<8; ++j)
        {
          if (j==2 && sstatus[-a[zet[i][2]]]==1) continue;
          if (j!=2 && !overzwart && !sstatus[-a[zet[i][2]]]) continue;
          if (szwart[j])
          {
            zet[i][4]=j;
            ++k;
            st=doezetwit(i, &h1, &h2);
            time=tijd/(aantal-ii++);
            som+=analysezwart(niv+1, his2, i, MINOE, PLUSOE, time, rt)+tel;
            tijd+=*rt-time;
            herstelzetwit(i, h1, h2, st);
          }
        }
        if (k==0 && szwart[SPION] && (overzwart || sstatus[-a[zet[i][2]]]))
        {
          zet[i][4]=SPION;
          ++k;
          st=doezetwit(i, &h1, &h2);
          time=tijd/(aantal-ii++);
          som+=analysezwart(niv+1, his2, i, MINOE, PLUSOE, time, rt)+tel;
          tijd+=*rt-time;
          herstelzetwit(i, h1, h2, st);
        }
      }
      if (k==0) {zet[i][4]=WITWINST-niv; continue;}
      u=som/k;
      if (u>grootste) grootste=u;
    }
    zet[i][4]=u;
  }
}

void berekenzwart(int n, int niv, int his2, long tijd, long *rt)
{
  int i, j, k, kleinste=PLUSOE, st, h1, h2, u, som, tel, aantal=0, ii;
  long time;
  
  for (i=2; i<pvul; ++i)
  {
    if (zet[i][0]==SCHUIF)
    { 
      ++aantal;
    }
    else if (sbekend[a[zet[i][2]]])
    {
      ++aantal;
    }
    else
    {
      k=0; som=0;
      if (sbekend[-a[zet[i][1]]])
      {
        for (j=2; j<9; ++j)
        {
          if (j==2 && sstatus[a[zet[i][2]]]==1) continue;
          if (j!=2 && !overwit && !sstatus[a[zet[i][2]]]) continue;
          if (swit[j])
          {
            ++k; ++aantal;
          }
        }
      }
      else
      {
        for (j=2; j<8; ++j)
        {
          if (j==2 && sstatus[a[zet[i][2]]]==1) continue;
          if (j!=2 && !overwit && !sstatus[a[zet[i][2]]]) continue;
          if (swit[j])
          {
            ++k; ++aantal;
          }
        }
        if (k==0 && swit[SPION] && (overwit || sstatus[a[zet[i][2]]]))
        {
          ++k; ++aantal;
        }
      }
      if (k==0) {continue;}
    }
  }
  
  ii=0;  
  for (i=2; i<pvul; ++i)
  {
    tel=n*(telafstandzwart(zet[i][1])-telafstandzwart(zet[i][2]));
    if (zet[i][0]==SCHUIF)
    {
      st=doezetzwart(i, &h1, &h2);
      time=tijd/(aantal-ii++);
      u=analysewit(niv+1, his2, i, MINOE, PLUSOE, time, rt)-tel;
      tijd+=*rt-time;
      if (u<kleinste) kleinste=u;
      herstelzetzwart(i, h1, h2, st);
    }
    else if (sbekend[a[zet[i][2]]])
    {
      zet[i][4]=sbekend[a[zet[i][2]]];
      st=doezetzwart(i, &h1, &h2);
      time=tijd/(aantal-ii++);
      u=analysewit(niv+1, his2, i, MINOE, PLUSOE, time, rt)-tel;
      tijd+=*rt-time;
      if (u<kleinste) kleinste=u;
      herstelzetzwart(i, h1, h2, st);
    }
    else
    {
      k=0; som=0;
      if (sbekend[-a[zet[i][1]]])
      {
        som=MINOE;
        for (j=2; j<9; ++j)
        {
          if (j==2 && sstatus[a[zet[i][2]]]==1) continue;
          if (j!=2 && !overwit && !sstatus[a[zet[i][2]]]) continue;
          if (swit[j])
          {
            zet[i][4]=j;
            ++k;
            st=doezetzwart(i, &h1, &h2);
            time=tijd/(aantal-ii++);
            u=analysewit(niv+1, his2, i, MINOE, PLUSOE, time, rt)-tel;
            if (u>som) som=u;
            tijd+=*rt-time;
            herstelzetzwart(i, h1, h2, st);
          }
        }
        if (k) k=1;
      }
      else
      {
        for (j=2; j<8; ++j)
        {
          if (j==2 && sstatus[a[zet[i][2]]]==1) continue;
          if (j!=2 && !overwit && !sstatus[a[zet[i][2]]]) continue;
          if (swit[j])
          {
            zet[i][4]=j;
            ++k;
            st=doezetzwart(i, &h1, &h2);
            time=tijd/(aantal-ii++);
            som+=analysewit(niv+1, his2, i, MINOE, PLUSOE, time, rt)-tel;
            tijd+=*rt-time;
            herstelzetzwart(i, h1, h2, st);
          }
        }
        if (k==0 && swit[SPION] && (overwit || sstatus[a[zet[i][2]]]))
        {
          zet[i][4]=SPION;
          ++k;
          st=doezetzwart(i, &h1, &h2);
          time=tijd/(aantal-ii++);
          som+=analysewit(niv+1, his2, i, MINOE, PLUSOE, time, rt)-tel;
          tijd+=*rt-time;
          herstelzetzwart(i, h1, h2, st);
        }
      }
      if (k==0) {zet[i][4]=ZWARTWINST+niv; continue;}
      u=som/k;
      if (u<kleinste) kleinste=u;
    }
    zet[i][4]=u;
  }
}

int analysewit(int niv, int his1, int his2, int alfa, int beta, long tijd, long *rt)
{
  int i, j, k, grootste, st, h1, h2, u, som, aa, pb=pvul, aantal=0, ii;
  long time;
  *rt=--tijd;
  zoekzetwit(his1);
  if (pvul==pb) return ZWARTWINST+niv;
  
  for (i=pb; i<pvul; ++i)
  {
    if (zet[i][0]==SCHUIF)
    {
      ++aantal;
    }
    else if (sbekend[-a[zet[i][2]]])
    {
      ++aantal;
    }
    else
    {
      k=0;
      if (sbekend[a[zet[i][1]]])
      {
        for (j=2; j<9; ++j)
        {
          if (j==2 && sstatus[-a[zet[i][2]]]==1) continue;
          if (j!=2 && !overzwart && !sstatus[-a[zet[i][2]]]) continue;
          if (szwart[j])
          {
            ++k; ++aantal;
          }
        }
      }
      else
      {
        for (j=2; j<8; ++j)
        {
          if (j==2 && sstatus[-a[zet[i][2]]]==1) continue;
          if (j!=2 && !overzwart && !sstatus[-a[zet[i][2]]]) continue;
          if (szwart[j])
          {
            ++k; ++aantal;
          }
        }
        if (k==0 && szwart[SPION] && (overzwart || sstatus[-a[zet[i][2]]]))
        {
          ++k; ++aantal;
        }
      }
      if (k==0) {pvul=pb; return WITWINST-niv;}
    }
  }
  
  if (tijd<aantal) {pvul=pb; return punttel();}
  grootste=MINOE; aa=alfa;
  ii=0;
  for (i=pb; i<pvul; ++i)
  {
    if (zet[i][0]==SCHUIF)
    {
      st=doezetwit(i, &h1, &h2);
      time=tijd/(aantal-ii++);
      u=analysezwart(niv+1, his2, i, MINOE, PLUSOE, time, rt);
      tijd+=*rt-time;
      if (u>grootste) grootste=u;
      if (grootste>aa) aa=grootste;
      herstelzetwit(i, h1, h2, st);
      if (grootste>=beta) break;
    }
    else if (sbekend[-a[zet[i][2]]])
    {
      zet[i][4]=sbekend[-a[zet[i][2]]];
      st=doezetwit(i, &h1, &h2);
      time=tijd/(aantal-ii++);
      u=analysezwart(niv+1, his2, i, MINOE, PLUSOE, time, rt);
      tijd+=*rt-time;
      if (u>grootste) grootste=u;
      if (grootste>aa) aa=grootste;
      herstelzetwit(i, h1, h2, st);
      if (grootste>=beta) break;
    }
    else
    {
      k=0; som=0;
      if (sbekend[a[zet[i][1]]])
      {
        som=PLUSOE;
        for (j=2; j<9; ++j)
        {
          if (j==2 && sstatus[-a[zet[i][2]]]==1) continue;
          if (j!=2 && !overzwart && !sstatus[-a[zet[i][2]]]) continue;
          if (szwart[j])
          {
            zet[i][4]=j;
            ++k;
            st=doezetwit(i, &h1, &h2);
            time=tijd/(aantal-ii++);
            u=analysezwart(niv+1, his2, i, MINOE, PLUSOE, time, rt);
            if (u<som) som=u;
            tijd+=*rt-time;
            herstelzetwit(i, h1, h2, st);
          }
        }
        if (k) k=1;
      }
      else
      {
        for (j=2; j<8; ++j)
        {
          if (j==2 && sstatus[-a[zet[i][2]]]==1) continue;
          if (j!=2 && !overzwart && !sstatus[-a[zet[i][2]]]) continue;
          if (szwart[j])
          {
            zet[i][4]=j;
            ++k;
            st=doezetwit(i, &h1, &h2);
            time=tijd/(aantal-ii++);
            som+=analysezwart(niv+1, his2, i, MINOE, PLUSOE, time, rt);
            tijd+=*rt-time;
            herstelzetwit(i, h1, h2, st);
          }
        }
        if (k==0 && szwart[SPION] && (overzwart || sstatus[-a[zet[i][2]]]))
        {
          zet[i][4]=SPION;
          ++k;
          st=doezetwit(i, &h1, &h2);
          time=tijd/(aantal-ii++);
          som=analysezwart(niv+1, his2, i, MINOE, PLUSOE, time, rt);
          tijd+=*rt-time;
          herstelzetwit(i, h1, h2, st);
        }
      }
//    if (k==0) {pvul=pb; return WITWINST-niv;}
      u=som/k;
      if (u>grootste) grootste=u;
      if (grootste>aa) aa=grootste;
      if (grootste>=beta) break;
    }
  }
  pvul=pb;
  return grootste;
}

int analysezwart(int niv, int his1, int his2, int alfa, int beta, long tijd, long *rt)
{
  int i, j, k, kleinste, st, h1, h2, u, som, bb, pb=pvul, aantal=0, ii;
  long time;
  *rt=--tijd;
  zoekzetzwart(his1);
  if (pvul==pb) return WITWINST-niv;

  for (i=pb; i<pvul; ++i)
  {
    if (zet[i][0]==SCHUIF)
    {
      ++aantal;
    }
    else if (sbekend[a[zet[i][2]]])
    {
      ++aantal; 
    }
    else
    {
      k=0;
      if (sbekend[-a[zet[i][1]]])
      {
        for (j=2; j<9; ++j)
        {
          if (j==2 && sstatus[a[zet[i][2]]]==1) continue;
          if (j!=2 && !overwit && !sstatus[a[zet[i][2]]]) continue;
          if (swit[j])
          {
            ++k; ++aantal;
          }
        }
      }
      else
      {
        for (j=2; j<8; ++j)
        {
          if (j==2 && sstatus[a[zet[i][2]]]==1) continue;
          if (j!=2 && !overwit && !sstatus[a[zet[i][2]]]) continue;
          if (swit[j])
          {
            ++k; ++aantal;
          }
        }
        if (k==0 && swit[SPION] && (overwit || sstatus[a[zet[i][2]]]))
        {
          ++k; ++aantal;
        }
      }
      if (k==0) {pvul=pb; return ZWARTWINST+niv;}
    }
  }

  if (tijd<aantal) {pvul=pb; return punttel();}
  kleinste=PLUSOE; bb=beta;
  ii=0;
  for (i=pb; i<pvul; ++i)
  {
    if (zet[i][0]==SCHUIF)
    {
      st=doezetzwart(i, &h1, &h2);
      time=tijd/(aantal-ii++);
      u=analysewit(niv+1, his2, i, MINOE, PLUSOE, time, rt);
      tijd+=*rt-time;
      if (u<kleinste) kleinste=u;
      if (kleinste<bb) bb=kleinste;
      herstelzetzwart(i, h1, h2, st);
      if (kleinste<=alfa) break;
    }
    else if (sbekend[a[zet[i][2]]])
    {
      zet[i][4]=sbekend[a[zet[i][2]]];
      st=doezetzwart(i, &h1, &h2);
      time=tijd/(aantal-ii++);
      u=analysewit(niv+1, his2, i, MINOE, PLUSOE, time, rt);
      tijd+=*rt-time;
      if (u<kleinste) kleinste=u;
      if (kleinste<bb) bb=kleinste;
      herstelzetzwart(i, h1, h2, st);
      if (kleinste<=alfa) break;
    }
    else
    {
      k=0; som=0;
      if (sbekend[-a[zet[i][1]]])
      {
        som=MINOE;
        for (j=2; j<9; ++j)
        {
          if (j==2 && sstatus[a[zet[i][2]]]==1) continue;
          if (j!=2 && !overwit && !sstatus[a[zet[i][2]]]) continue;
          if (swit[j])
          {
            zet[i][4]=j;
            ++k;
            st=doezetzwart(i, &h1, &h2);
            time=tijd/(aantal-ii++);
            u=analysewit(niv+1, his2, i, MINOE, PLUSOE, time, rt);
            if (u>som) som=u;
            tijd+=*rt-time;
            herstelzetzwart(i, h1, h2, st);
          }
        }
        if (k) k=1;
      }
      else
      {
        for (j=2; j<8; ++j)
        {
          if (j==2 && sstatus[a[zet[i][2]]]==1) continue;
          if (j!=2 && !overwit && !sstatus[a[zet[i][2]]]) continue;
          if (swit[j])
          {
            zet[i][4]=j;
            ++k;
            st=doezetzwart(i, &h1, &h2);
            time=tijd/(aantal-ii++);
            som+=analysewit(niv+1, his2, i, MINOE, PLUSOE, time, rt);
            tijd+=*rt-time;
            herstelzetzwart(i, h1, h2, st);
          }
        }
        if (k==0 && swit[SPION] && (overwit || sstatus[a[zet[i][2]]]))
        {
          zet[i][4]=SPION;
          ++k;
          st=doezetzwart(i, &h1, &h2);
          time=tijd/(aantal-ii++);
          som=analysewit(niv+1, his2, i, MINOE, PLUSOE, time, rt);
          tijd+=*rt-time;
          herstelzetzwart(i, h1, h2, st);
        }
      }
//    if (k==0) {pvul=pb; return ZWARTWINST+niv;}
      u=som/k;
      if (u<kleinste) kleinste=u;
      if (kleinste<bb) bb=kleinste;
      if (kleinste<=alfa) break;
    }
  }
  pvul=pb;
  return kleinste;
}

void berekenstukwit2(int niv, int his2, int x)
{
  int i, j, m, u, grootste=MINOE, z=0, h1, h2, st, k, l, som, aantal=0, ii;
  long rt=0, time, tijd=6*tijdber;
  pvul=2;

  if (sbekend[a[zet[x][2]]]) z=sbekend[a[zet[x][2]]];
  else if (sbekend[-a[zet[x][1]]])
  {
    for (j=2; j<8; ++j)
    {
      if (j==2 && sstatus[a[zet[x][2]]]==1) continue;
      if (j!=2 && !overwit && !sstatus[a[zet[x][2]]]) continue;
      if (swit[j])
      {
        ++aantal;
      }
    }
  }
  else
  {
    for (j=2; j<8; ++j)
    {
      if (j==2 && sstatus[a[zet[x][2]]]==1) continue;
      if (j!=2 && !overwit && !sstatus[a[zet[x][2]]]) continue;
      if (swit[j])
      {
        for (i=3; i<9; ++i) if (szwart[i] && (overzwart || sstatus[-a[zet[x][1]]]))
        {
          ++aantal;
        }
      }
    }
  }

  ii=0;
  if (sbekend[a[zet[x][2]]]) z=sbekend[a[zet[x][2]]];
  else if ((m=sbekend[-a[zet[x][1]]]))
  {
    zet[x][3]=m;
    k=0;
    for (j=2; j<8; ++j)
    {
      if (j==2 && sstatus[a[zet[x][2]]]==1) continue;
      if (j!=2 && !overwit && !sstatus[a[zet[x][2]]]) continue;
      if (swit[j])
      {
        zet[x][4]=j;
        ++k;
        st=doezetzwart(x, &h1, &h2);
        time=tijd/(aantal-ii++);
        u=analysewit(niv+1, his2, x, MINOE, PLUSOE, time, &rt);
        tijd+=rt-time;
        if (u>grootste) {grootste=u; z=j;}
        herstelzetzwart(x, h1, h2, st);
      }
    }
    if (k==0 && swit[SPION] && (overwit || sstatus[a[zet[x][2]]])) {++k; z=SPION;}
    if (k==0) z=VLAG;
  }
  else
  {
    k=0;
    for (j=2; j<8; ++j)
    {
      if (j==2 && sstatus[a[zet[x][2]]]==1) continue;
      if (j!=2 && !overwit && !sstatus[a[zet[x][2]]]) continue;
      if (swit[j])
      {
        zet[x][4]=j;
        ++k;
        som=0; l=0;
        for (i=3; i<9; ++i) if (szwart[i] && (overzwart || sstatus[-a[zet[x][1]]]))
        {
          zet[x][3]=i;
          ++l;
          st=doezetzwart(x, &h1, &h2);
          time=tijd/(aantal-ii++);
          som+=analysewit(niv+1, his2, x, MINOE, PLUSOE, time, &rt);
          tijd+=rt-time;
          herstelzetzwart(x, h1, h2, st);
        }
        u=som/l;
        if (u>grootste) {grootste=u; z=j;}
      }
    }
    if (k==0 && swit[SPION] && (overwit || sstatus[a[zet[x][2]]])) {++k; z=SPION;}
    if (k==0) z=VLAG;
  }
  zet[x][4]=z;  
}

void berekenstukzwart2(int niv, int his2, int x)
{
  int i, j, m, u, kleinste=PLUSOE, z=0, h1, h2, st, k, l, som, aantal=0, ii;
  long rt=0, time, tijd=6*tijdber;
  pvul=2;

  if (sbekend[-a[zet[x][2]]]) z=sbekend[-a[zet[x][2]]];
  else if ((m=sbekend[a[zet[x][1]]]))
  {
    for (j=2; j<8; ++j)
    {
      if (j==2 && sstatus[-a[zet[x][2]]]==1) continue;
      if (j!=2 && !overzwart && !sstatus[-a[zet[x][2]]]) continue;
      if (szwart[j])
      {
        ++aantal;
      }
    }
  }
  else
  {
    for (j=2; j<8; ++j)
    {
      if (j==2 && sstatus[-a[zet[x][2]]]==1) continue;
      if (j!=2 && !overzwart && !sstatus[-a[zet[x][2]]]) continue;
      if (szwart[j])
      {
        for (i=3; i<9; ++i) if (swit[i] && (overwit || sstatus[a[zet[x][1]]]))
        {
          ++aantal;
        }
      }
    }
  }

  ii=0;
  if (sbekend[-a[zet[x][2]]]) z=sbekend[-a[zet[x][2]]];
  else if ((m=sbekend[a[zet[x][1]]]))
  {
    zet[x][3]=m;
    k=0;
    for (j=2; j<8; ++j)
    {
      if (j==2 && sstatus[-a[zet[x][2]]]==1) continue;
      if (j!=2 && !overzwart && !sstatus[-a[zet[x][2]]]) continue;
      if (szwart[j])
      {
        zet[x][4]=j;
        ++k;
        st=doezetwit(x, &h1, &h2);
        time=tijd/(aantal-ii++);
        u=analysezwart(niv+1, his2, x, MINOE, PLUSOE, time, &rt);
        tijd+=rt-time;
        if (u<kleinste) {kleinste=u; z=j;}
        herstelzetwit(x, h1, h2, st);
      }
    }
    if (k==0 && szwart[SPION] && (overzwart || sstatus[-a[zet[x][2]]])) {++k; z=SPION;}
    if (k==0) z=VLAG;
  }
  else
  {
    k=0;
    for (j=2; j<8; ++j)
    {
      if (j==2 && sstatus[-a[zet[x][2]]]==1) continue;
      if (j!=2 && !overzwart && !sstatus[-a[zet[x][2]]]) continue;
      if (szwart[j])
      {
        zet[x][4]=j;
        ++k;
        som=0; l=0;
        for (i=3; i<9; ++i) if (swit[i] && (overwit || sstatus[a[zet[x][1]]]))
        {
          zet[x][3]=i;
          ++l;
          st=doezetwit(x, &h1, &h2);
          time=tijd/(aantal-ii++);
          som+=analysezwart(niv+1, his2, x, MINOE, PLUSOE, time, &rt);
          tijd+=rt-time;
          herstelzetwit(x, h1, h2, st);
        }
        u=som/l;
        if (u<kleinste) {kleinste=u; z=j;}
      }
    }
    if (k==0 && szwart[SPION] && (overzwart || sstatus[-a[zet[x][2]]])) {++k; z=SPION;}
    if (k==0) z=VLAG;
  }
  zet[x][4]=z;  
}

char *vertaalzet(int x)
{
  static char y[6];
  int f, t;
  f=zet[x][1];
  t=zet[x][2];
  if (f>24) ++f;
  if (f>21) ++f;
  if (t>24) ++t;
  if (t>21) ++t;
  if (t-f==1 || f-t==1)
  {
    y[0]=f%7+'a';
    y[1]=7-f/7+'0';
    y[3]=t%7+'a';
    y[4]=y[1];
  }
  else
  {
    y[0]=f%7+'a';
    y[1]=7-f/7+'0';
    y[3]=y[0];
    y[4]=7-t/7+'0';
  }
  y[2]='-';
  y[5]='\0';
  return y;
}

char *vertaalstuk1(int x)
{
  static char y[2];
  switch(zet[x][3])
  {
    case VLAG: y[0]='V'; break;
    case BOM: y[0]='B'; break;
    case GENERAAL: y[0]='G'; break;
    case OVERSTE: y[0]='O'; break;
    case LUITENANT: y[0]='L'; break;
    case MONTEUR: y[0]='M'; break;
    case RUITER: y[0]='R'; break;
    case SPION: y[0]='S'; break;
  }
  y[1]='\0';
  return y;
}

char *vertaalstuk2(int x)
{
  static char y[2];
  switch(zet[x][4])
  {
    case VLAG: y[0]='V'; break;
    case BOM: y[0]='B'; break;
    case GENERAAL: y[0]='G'; break;
    case OVERSTE: y[0]='O'; break;
    case LUITENANT: y[0]='L'; break;
    case MONTEUR: y[0]='M'; break;
    case RUITER: y[0]='R'; break;
    case SPION: y[0]='S'; break;
  }
  y[1]='\0';
  return y;
}

void voegtoeaanzet1(char x, int y)
{
  switch(x)
  {
    case 'V': zet[y][3]=VLAG; break;
    case 'B': zet[y][3]=BOM; break;
    case 'G': zet[y][3]=GENERAAL; break;
    case 'O': zet[y][3]=OVERSTE; break;
    case 'L': zet[y][3]=LUITENANT; break;
    case 'M': zet[y][3]=MONTEUR; break;
    case 'R': zet[y][3]=RUITER; break;
    case 'S': zet[y][3]=SPION; break;
  }
  return;
}

void voegtoeaanzet2(char x, int y)
{
  switch(x)
  {
    case 'V': zet[y][4]=VLAG; break;
    case 'B': zet[y][4]=BOM; break;
    case 'G': zet[y][4]=GENERAAL; break;
    case 'O': zet[y][4]=OVERSTE; break;
    case 'L': zet[y][4]=LUITENANT; break;
    case 'M': zet[y][4]=MONTEUR; break;
    case 'R': zet[y][4]=RUITER; break;
    case 'S': zet[y][4]=SPION; break;
  }
  return;
}

void vulzet(char *x, int y)
{
  int f, t;
  f=7*(7-x[1]+'0')+(x[0]-'a');
  t=7*(7-x[4]+'0')+(x[3]-'a');
  if (f>26) --f;
  if (f>22) --f;
  if (t>26) --t;
  if (t>22) --t;
  zet[y][1]=f;
  zet[y][2]=t;
  if (a[t]) zet[y][0]=SLA; else zet[y][0]=SCHUIF;
  return;
}
/*
void zoek(int diepte, int plek, int i)
{
  int j=0;
  do
  {
    if (plek==b[i][j]) continue;
    if (afstand[plek][b[i][j]]==0)
    {
      afstand[plek][b[i][j]]=diepte;
    }
    if (afstand[plek][b[i][j]]>diepte)
    {
      afstand[plek][b[i][j]]=diepte;    
    }
  } while (b[i][++j]!=-1);
  j=0;
  do
  {
    if (plek==b[i][j]) continue;
    if (afstand[plek][b[i][j]]==diepte)
    {
      zoek(diepte+1, plek, b[i][j]);
    }
  } while (b[i][++j]!=-1);
}
*/

int main(void)
{
  int i, keuze, h1, h2, n=1;
  char invoer[6];
  struct timeval start, stop;
  long timedone=0;
  fprintf(stderr, "S versie6VBLCS\n"); fflush(stderr);
  scanf("%s", invoer);
  if (invoer[0]=='S') while (1)
  {
    kleur=250;
    gettimeofday(&start, NULL);
    pvul=2; zoekzetwit(0); if (pvul==2) break;
    keuze=berekenzetwit(n, 0, 1);
//  for (i=2; i<pvul; ++i)
//  {
//    printf("%3d %3d %3d %3d %3d %3d\n", i, zet[i][0], zet[i][1], zet[i][2], zet[i][3], zet[i][4]);
//  }
    printf("%s\n", vertaalzet(keuze));
    gettimeofday(&stop, NULL);
    timedone+=1000000*(stop.tv_sec-start.tv_sec)+stop.tv_usec-start.tv_usec;
    fprintf(stderr, "tijd=%ld\n", timedone/1000); fflush(stderr);
    fflush(stdout);
    if (zet[keuze][0]==SLA)
    {
      printf("%s\n", vertaalstuk1(keuze));
      fflush(stdout);
      scanf("%s", invoer);
      if (invoer[0]=='X' || invoer[0]=='V') break;
      voegtoeaanzet2(invoer[0], keuze);
    }
    doezetwit(keuze, &h1, &h2);
//  printbord();
    for (i=0; i<5; ++i) zet[0][i]=zet[keuze][i];
    gettimeofday(&start, NULL);
    pvul=2; zoekzetzwart(1); if (pvul==2) break;
    gettimeofday(&stop, NULL);
    timedone+=1000000*(stop.tv_sec-start.tv_sec)+stop.tv_usec-start.tv_usec;
    fprintf(stderr, "tijd=%ld\n", timedone/1000); fflush(stderr);
    scanf("%s", invoer);
    if (invoer[0]=='X') break;
    vulzet(invoer, 1);
    if (zet[1][0]==SLA)
    {
      gettimeofday(&start, NULL);
      berekenstukwit2(0, 0, 1);
      printf("%s\n", vertaalstuk2(1));
      gettimeofday(&stop, NULL);
      timedone+=1000000*(stop.tv_sec-start.tv_sec)+stop.tv_usec-start.tv_usec;
      fprintf(stderr, "tijd=%ld\n", timedone/1000); fflush(stderr);
      fflush(stdout);
      if (zet[1][4]==VLAG) break;
      scanf("%s", invoer);
      if (invoer[0]=='X') break;
      voegtoeaanzet1(invoer[0], 1);
    }
    doezetzwart(1, &h1, &h2);
    if (++n>200) break;
nn=n;
//  printbord();
  }
  else while (1)
  {
    kleur=-250;
    vulzet(invoer, 1);
    if (zet[1][0]==SLA)
    {
      gettimeofday(&start, NULL);
      berekenstukzwart2(0, 0, 1);
      printf("%s\n", vertaalstuk2(1));
      gettimeofday(&stop, NULL);
      timedone+=1000000*(stop.tv_sec-start.tv_sec)+stop.tv_usec-start.tv_usec;
      fprintf(stderr, "tijd=%ld\n", timedone/1000); fflush(stderr);
      fflush(stdout);
      if (zet[1][4]==VLAG) break;
      scanf("%s", invoer);
      if (invoer[0]=='X') break;
      voegtoeaanzet1(invoer[0], 1);
    }
    doezetwit(1, &h1, &h2);
//  printbord();
    gettimeofday(&start, NULL);
    pvul=2; zoekzetzwart(0); if (pvul==2) break;
    keuze=berekenzetzwart(n, 0, 1);
//  for (i=2; i<pvul; ++i)
//  {
//    printf("%3d %3d %3d %3d %3d %3d\n", i, zet[i][0], zet[i][1], zet[i][2], zet[i][3], zet[i][4]);
//  }
    printf("%s\n", vertaalzet(keuze));
    gettimeofday(&stop, NULL);
    timedone+=1000000*(stop.tv_sec-start.tv_sec)+stop.tv_usec-start.tv_usec;
    fprintf(stderr, "tijd=%ld\n", timedone/1000); fflush(stderr);
    fflush(stdout);
    if (zet[keuze][0]==SLA)
    {
      printf("%s\n", vertaalstuk1(keuze));
      fflush(stdout);
      scanf("%s", invoer);
      if (invoer[0]=='X' || invoer[0]=='V') break;
      voegtoeaanzet2(invoer[0], keuze);
    }
    if (++n>200) break;
nn=n;
    doezetzwart(keuze, &h1, &h2);
//  printbord();
    for (i=0; i<5; ++i) zet[0][i]=zet[keuze][i];
    gettimeofday(&start, NULL);
    pvul=2; zoekzetwit(1); if (pvul==2) break;
    gettimeofday(&stop, NULL);
    timedone+=1000000*(stop.tv_sec-start.tv_sec)+stop.tv_usec-start.tv_usec;
    fprintf(stderr, "tijd=%ld\n", timedone/1000); fflush(stderr);
    scanf("%s", invoer);
    if (invoer[0]=='X') break;
  }
  return 0;
}
