{* Copyright (C) 2004 Willem van der Vegt.

This file is part of the Caia project. This project can be
downloaded from the website www.codecup.nl. You can email to
marcel@vlastuin.net or write to Marcel Vlastuin, Perenstraat 40,
2564 SE Den Haag, The Netherlands.

*}

program CodeCup;
{ debug version using colors
  version d1; other selection mechanism
 }

(* {$DEFINE debug} *)

{$IFDEF debug}
uses crt;
{$ENDIF}
{
 Example of a Lamistra player program for the CodeCup.

 This only demonstrates how to do the input and output. You will
 have to write the algorithms for the game all by yourself.
}

{ statustype: IO is determined by the actual status }

type statustype=(init,tomove,attacking,waiting,attacked,defending,ready);
     roletype=(flag,bomb,general,coronel,lieutenant,minor,rider,spy);
     contenttype=(redpiece,bluepiece,empty,forbidden);
     celltype=record
                content: contenttype;
                pieceno: integer
              end;
     piecetype=record
                 c,r: integer;
                 known,moved: boolean;
                 value: roletype
               end;
     movetype=record
                fc,fr,tc,tr: integer;
                capture: boolean;
                apc,dpc: roletype;
                score: integer
              end;

{ global variables }

var stat: statustype;  { what is the actual situation }
    line: string;      { line from standard input or to standard output }
    red: boolean;      { is the player playing with red? }
    nMoves: integer;   { number of moves played }
    fromcol,fromrow,tocol,torow: integer; {move parameters}
    rolechar: array[roletype] of char;    { the charactar indicating a role }
    chrole: array['B'..'V'] of roletype;  { the role indicated by a char }
    wintable: array[roletype,roletype] of boolean; { which role wins? }
    bag: array[roletype,boolean] of integer; { how many roles available }
    nbag,nmoved,nboard,counter: array[boolean] of integer; { counters }
    board: array[0..8,0..8] of celltype;      { game board }
    piece: array[1..21,boolean] of piecetype; { all pieces on the board }
    defense,attackpiece: roletype;
    movelist: array[1..84] of movetype;
    moving,movesnumber: integer;
    nfc,nfr,ntc,ntr: integer; { forbidden move }
    w: array[1..7,1..7] of integer;
    result: array[roletype] of integer;

{ Debug related items }
{$IFDEF debug}
procedure fastwrite(s: string; r,c,cl: integer);
begin
  textbackground(cl div 16);
  textcolor(cl mod 16);
  gotoxy(c,r);
  write(s);
  textcolor(7);
  textbackground(0)
end;

procedure ShowCell(n,m: integer);
var blue: boolean;
    paint: integer;
begin
  with board[n,m] do
  begin
    if content=empty then fastwrite('---',16-2*m,4*n-2,8) else
    if content=forbidden then fastwrite('XXX',16-2*m,4*n-2,11) else
    begin
      blue:=content=bluepiece;
      if blue then paint:=9 else paint:=12;
      with piece[pieceno,not blue] do
      begin
        if known then fastwrite(' '+rolechar[value]+' ',16-2*m,4*n-2,paint) else
        if moved then fastwrite('<?>',16-2*m,4*n-2,paint) else fastwrite('-?-',16-2*m,4*n-2,paint)
      end
    end
  end
end;

procedure ShowBoard;
var i,j: integer;
    h: string;
    rt: roletype;
begin
  write('*');
  readln;
  clrscr;
  fastwrite('Ŀ',1,1,8);
  fastwrite('                     ',2,1,8);
  fastwrite('Ĵ',3,1,8);
  fastwrite('                     ',4,1,8);
  fastwrite('Ĵ',5,1,8);
  fastwrite('                     ',6,1,8);
  fastwrite('Ĵ',7,1,8);
  fastwrite('                     ',8,1,8);
  fastwrite('Ĵ',9,1,8);
  fastwrite('                     ',10,1,8);
  fastwrite('Ĵ',11,1,8);
  fastwrite('                     ',12,1,8);
  fastwrite('Ĵ',13,1,8);
  fastwrite('                     ',14,1,8);
  fastwrite('',15,1,8);
  for i:=1 to 7 do for j:=1 to 7 do ShowCell(i,j);
  fastwrite('V B G O L M R S',1,38,8);
  for rt:=flag to spy do
  begin
    str(bag[rt,true],h);
    fastwrite(h,2,38+2*ord(rt),12);
    str(bag[rt,false],h);
    fastwrite(h,3,38+2*ord(rt),9)
  end;
  gotoxy(1,17)
end;
{$ENDIF}

{ Section with methods for pieces }

procedure SetValue(n: integer; rd: boolean; pv: roletype);
begin
  with piece[n,rd] do
  begin
    known:=true;
    if not(pv in [flag,bomb]) then
    begin
      if not moved then
      begin
        moved:=true;
        inc(nmoved[rd])
      end
    end;
    dec(nbag[rd]);
    dec(bag[pv,rd]);
    value:=pv
  end
end;

procedure MovePiece(n: integer; rd: boolean);
begin
  with piece[n,rd] do
  begin
    c:=tocol;
    r:=torow;
    if not moved then
    begin
      moved:=true;
      inc(nmoved[rd])
    end
  end;
  board[tocol,torow]:=board[fromcol,fromrow];
  board[fromcol,fromrow].content:=empty
end;

procedure RemovePiece(n: integer; rd: boolean);
begin
  with piece[n,rd] do
  begin
    board[c,r].content:=empty;
    c:=0;
    r:=0
  end;
  dec(nboard[rd])
end;

procedure SetForbiddenMove;
begin
  nfc:=tocol;
  nfr:=torow;
  ntc:=fromcol;
  ntr:=fromrow
end;

procedure ClearForbiddenMove;
begin
  nfc:=0;
  nfr:=0;
  ntc:=0;
  ntr:=0
end;

function Allowed(c0,r0,c1,r1: integer): boolean;
begin
  Allowed:=(c0<>nfc) or (r0<>nfr) or (c1<>ntc) or (r1<>ntr)
end;

{ This procedure initializes all variables }

procedure InitGame;
var r1,r2: roletype;
    col,row: integer;
begin { InitGame }
  stat:=init;
  nMoves:=0;

  { init the roles }

  rolechar[flag]:='V';
  rolechar[bomb]:='B';
  rolechar[general]:='G';
  rolechar[coronel]:='O';
  rolechar[lieutenant]:='L';
  rolechar[minor]:='M';
  rolechar[rider]:='R';
  rolechar[spy]:='S';
  chrole['V']:=flag;
  chrole['B']:=bomb;
  chrole['G']:=general;
  chrole['O']:=coronel;
  chrole['L']:=lieutenant;
  chrole['M']:=minor;
  chrole['R']:=rider;
  chrole['S']:=spy;
  for r1:=general to spy do for r2:=flag to spy do
  begin
    if r2=flag then wintable[r1,r2]:=true else
    if r2=bomb then
    begin
      if r1=minor then wintable[r1,r2]:=true else wintable[r1,r2]:=false
    end else
    if r1<r2 then wintable[r1,r2]:=true else
    if (r2=general) and (r1=spy) then wintable[r1,r2]:=true else
    wintable[r1,r2]:=false
  end;
  for red:=false to true do
  begin
    bag[flag,red]:=1;
    bag[bomb,red]:=4;
    bag[general,red]:=1;
    bag[coronel,red]:=2;
    bag[lieutenant,red]:=3;
    bag[minor,red]:=4;
    bag[rider,red]:=5;
    bag[spy,red]:=1;
    nbag[red]:=21;
    nmoved[red]:=0;
    nboard[red]:=21;
    counter[red]:=0
  end;

  { init the gameboard and pieces }

  for col:=0 to 8 do for row:=0 to 8 do with board[col,row] do
  begin
    if (col=0) or (col=8) or (row=0) or (row=8) then content:=forbidden else
    begin
      if row<4 then
      begin
        content:=redpiece;
        inc(counter[true]);
        pieceno:=counter[true];
        with piece[pieceno,true] do
        begin
          c:=col;
          r:=row;
          known:=false;
          moved:=false
        end
      end else if row=4 then
      begin
        if (col=2) or (col=6) then content:=forbidden
                              else content:=empty
      end else
      begin
        content:=bluepiece;
        inc(counter[false]);
        pieceno:=counter[false];
        with piece[pieceno,false] do
        begin
          c:=col;
          r:=row;
          known:=false;
          moved:=false
        end
      end
    end
  end;

  { init the movegenerator }

  for col:=1 to 7 do for row:=1 to 7 do
    w[col,row]:=4*(18-sqr(4-col)-sqr(4-row));
  result[flag]:=30000;
  result[bomb]:=800;
  result[general]:=500;
  result[coronel]:=400;
  result[lieutenant]:=200;
  result[minor]:=399;
  result[rider]:=100;
  result[spy]:=150

end; { InitGame }

{ This procedures inputs a line from standard input }

procedure readInputLine;
begin
  readln(line)
end;

{ This procedure outputs a line to standard output }

procedure writeOutputLine;
begin
  writeln(line);
  flush(output)
end;

{ This function checks if the To-field contains my piece }

function MyField(col,row: integer): boolean;
begin
  if red then MyField:=board[col,row].content=redpiece
         else MyField:=board[col,row].content=bluepiece
end;

function YourField(col,row: integer): boolean;
begin
  if red then YourField:=board[col,row].content=bluepiece
         else YourField:=board[col,row].content=redpiece
end;

{ This procedure is used to proces the move of the opponent }

procedure ProcesMove(s: string);
begin
  inc(nMoves);
  fromcol := ord(s[1]) - ord('a') + 1;
  fromrow := ord(s[2]) - ord('1') + 1;
  tocol := ord(s[4]) - ord('a') + 1;
  torow := ord(s[5]) - ord('1') + 1;
  if MyField(tocol,torow) then stat := attacked else
  begin
    MovePiece(board[fromcol,fromrow].pieceno,not red);
    {$IFDEF debug}
    ShowBoard;
    {$ENDIF}
    stat := tomove
  end;
end;


{ this procedure is used to select a move }

function FindCheapTake(drole: roletype): roletype;
var mine: roletype;
    found: boolean;
begin
  mine:=drole;
  found:=false;
  while not found and (mine>general) do
  begin
    dec(mine);
    if bag[mine,red]>0 then found:=true
  end;
  if not found then
  begin
    if (bag[drole,red]>0) and (drole<>bomb) then
    begin
      mine:=drole;
      found:=true
    end else
    begin
      mine:=spy;
      while bag[mine,red]=0 do dec(mine)
    end
  end;
  FindCheapTake:=mine
end;

function GuessRandom: roletype;
var mine: roletype;
    nlist,i,chosen: integer;
    list: array[1..16] of roletype;
begin
  nlist:=0;
  for mine:=general to spy do
  begin
    for i:=1 to bag[mine,red] do
    begin
      inc(nlist);
      list[nlist]:=mine
    end
  end;
  chosen:=1+random(nlist);
  GuessRandom:=list[chosen]
end;

function compare(a: roletype): integer;
var n,j,startvalue: integer;
    b: roletype;
begin
  startvalue:=0;
  n:=0;
  for b:=bomb to spy do
  begin
    if bag[b,not red]>0 then
    begin
      if wintable[a,b] then
      begin
        for j:=1 to bag[b,not red] do
        begin
          inc(n);
          startvalue:=startvalue+result[b]
        end
      end else if wintable[b,a] then
      begin
        for j:=1 to bag[b,not red] do
        begin
          inc(n);
          startvalue:=startvalue-result[a]
        end
      end else n:=n+bag[b,not red]
    end
  end;
  compare:=round(startvalue/n)
end;


procedure MakeMoveList;
var i: integer;
    a: roletype;
begin
  movesnumber:=0;
  for i:=1 to 21 do if piece[i,red].c>0 then with piece[i,red] do
  begin
    if moved or (not moved and (nmoved[red]<16)) then
    begin
      if board[c+1,r].content=empty then
      begin
        if Allowed(c,r,c+1,r) then
        begin
          inc(movesnumber);
          with movelist[movesnumber] do
          begin
            fc:=c;
            fr:=r;
            tc:=c+1;
            tr:=r;
            capture:=false;
            score:=w[tc,tr]-w[fc,fr]
          end
        end
      end else if YourField(c+1,r) then
      begin
        if known then
        begin
          inc(movesnumber);
          with movelist[movesnumber] do
          begin
            fc:=c;
            fr:=r;
            tc:=c+1;
            tr:=r;
            capture:=true;
            score:=300+w[tc,tr]-w[fc,fr];
            apc:=value;
            if piece[board[c+1,r].pieceno,not red].known then
            begin
              dpc:=piece[board[c+1,r].pieceno,not red].value;
              if wintable[dpc,apc] then score:=score-result[apc] else
              if wintable[apc,dpc] then score:=score+result[dpc]
            end else score:=score+compare(apc)
          end
        end else for a:=general to spy do if bag[a,red]>0 then
        begin
          inc(movesnumber);
          with movelist[movesnumber] do
          begin
            fc:=c;
            fr:=r;
            tc:=c+1;
            tr:=r;
            apc:=a;
            capture:=true;
            score:=300+w[tc,tr]-w[fc,fr];
            if piece[board[c+1,r].pieceno,not red].known then
            begin
              dpc:=piece[board[c+1,r].pieceno,not red].value;
              if wintable[dpc,apc] then score:=score-result[apc] else
              if wintable[apc,dpc] then score:=score+result[dpc]
            end else score:=score+compare(apc)
          end
        end
      end;
      if board[c,r+1].content=empty then
      begin
        if Allowed(c,r,c,r+1) then
        begin
          inc(movesnumber);
          with movelist[movesnumber] do
          begin
            fc:=c;
            fr:=r;
            tc:=c;
            tr:=r+1;
            capture:=false;
            score:=w[tc,tr]-w[fc,fr]
          end
        end
      end else if YourField(c,r+1) then
      begin
        if known then
        begin
          inc(movesnumber);
          with movelist[movesnumber] do
          begin
            fc:=c;
            fr:=r;
            tc:=c;
            tr:=r+1;
            capture:=true;
            score:=300+w[tc,tr]-w[fc,fr];
            apc:=value;
            if piece[board[c,r+1].pieceno,not red].known then
            begin
              dpc:=piece[board[c,r+1].pieceno,not red].value;
              if wintable[dpc,apc] then score:=score-result[apc] else
              if wintable[apc,dpc] then score:=score+result[dpc]
            end else score:=score+compare(apc)
          end
        end else for a:=general to spy do if bag[a,red]>0 then
        begin
          inc(movesnumber);
          with movelist[movesnumber] do
          begin
            fc:=c;
            fr:=r;
            tc:=c;
            tr:=r+1;
            apc:=a;
            capture:=true;
            score:=300+w[tc,tr]-w[fc,fr];
            if piece[board[c,r+1].pieceno,not red].known then
            begin
              dpc:=piece[board[c,r+1].pieceno,not red].value;
              if wintable[dpc,apc] then score:=score-result[apc] else
              if wintable[apc,dpc] then score:=score+result[dpc]
            end else score:=score+compare(apc)
          end
        end
      end;
      if board[c-1,r].content=empty then
      begin
        if Allowed(c,r,c-1,r) then
        begin
          inc(movesnumber);
          with movelist[movesnumber] do
          begin
            fc:=c;
            fr:=r;
            tc:=c-1;
            tr:=r;
            capture:=false;
            score:=w[tc,tr]-w[fc,fr]
          end
        end
      end else if YourField(c-1,r) then
      begin
        if known then
        begin
          inc(movesnumber);
          with movelist[movesnumber] do
          begin
            fc:=c;
            fr:=r;
            tc:=c-1;
            tr:=r;
            capture:=true;
            score:=300+w[tc,tr]-w[fc,fr];
            apc:=value;
            if piece[board[c-1,r].pieceno,not red].known then
            begin
              dpc:=piece[board[c-1,r].pieceno,not red].value;
              if wintable[dpc,apc] then score:=score-result[apc] else
              if wintable[apc,dpc] then score:=score+result[dpc]
            end else score:=score+compare(apc)
          end
        end else for a:=general to spy do if bag[a,red]>0 then
        begin
          inc(movesnumber);
          with movelist[movesnumber] do
          begin
            fc:=c;
            fr:=r;
            tc:=c-1;
            tr:=r;
            apc:=a;
            capture:=true;
            score:=300+w[tc,tr]-w[fc,fr];
            if piece[board[c-1,r].pieceno,not red].known then
            begin
              dpc:=piece[board[c-1,r].pieceno,not red].value;
              if wintable[dpc,apc] then score:=score-result[apc] else
              if wintable[apc,dpc] then score:=score+result[dpc]
            end else score:=score+compare(apc)
          end
        end
      end;
      if board[c,r-1].content=empty then
      begin
        if Allowed(c,r,c,r-1) then
        begin
          inc(movesnumber);
          with movelist[movesnumber] do
          begin
            fc:=c;
            fr:=r;
            tc:=c;
            tr:=r-1;
            capture:=false;
            score:=w[tc,tr]-w[fc,fr]
          end
        end
      end else if YourField(c,r-1) then
      begin
        if known then
        begin
          inc(movesnumber);
          with movelist[movesnumber] do
          begin
            fc:=c;
            fr:=r;
            tc:=c;
            tr:=r-1;
            capture:=true;
            score:=300+w[tc,tr]-w[fc,fr];
            apc:=value;
            if piece[board[c,r-1].pieceno,not red].known then
            begin
              dpc:=piece[board[c,r-1].pieceno,not red].value;
              if wintable[dpc,apc] then score:=score-result[apc] else
              if wintable[apc,dpc] then score:=score+result[dpc]
            end else score:=score+compare(apc)
          end
        end else for a:=general to spy do if bag[a,red]>0 then
        begin
          inc(movesnumber);
          with movelist[movesnumber] do
          begin
            fc:=c;
            fr:=r;
            tc:=c;
            tr:=r-1;
            apc:=a;
            capture:=true;
            score:=300+w[tc,tr]-w[fc,fr];
            if piece[board[c,r-1].pieceno,not red].known then
            begin
              dpc:=piece[board[c,r-1].pieceno,not red].value;
              if wintable[dpc,apc] then score:=score-result[apc] else
              if wintable[apc,dpc] then score:=score+result[dpc]
            end else score:=score+compare(apc)
          end
        end
      end
    end
  end
end;

procedure PickMove(var picked: integer);
var i,b,bs: integer;
begin
  bs:=movelist[1].score;
  b:=1;
  for i:=2 to movesnumber do if movelist[i].score>bs then
  begin
    bs:=movelist[i].score;
    b:=i
  end;
  picked:=b;
  fromcol:=movelist[picked].fc;
  fromrow:=movelist[picked].fr;
  tocol:=movelist[picked].tc;
  torow:=movelist[picked].tr;
  SetForbiddenMove;
  moving:=board[fromcol,fromrow].pieceno;
  if movelist[picked].capture then
  begin
    attackpiece:=movelist[picked].apc;
    ClearForbiddenMove;
    if not(piece[board[fromcol,fromrow].pieceno,red].known) then
      SetValue(board[fromcol,fromrow].pieceno,red,attackpiece)
  end
end;

procedure SelectMove(var s: string; var a: boolean; var l: char);
var moveno: integer;
begin
  MakeMoveList;
  if movesnumber=0 then s:='X' else
  begin
    PickMove(moveno);
    with movelist[moveno] do
    begin
      a:=capture;
      s:=chr(ord('a')-1+fc)+
         chr(ord('0')+fr)+'-'+
         chr(ord('a')-1+tc)+
         chr(ord('0')+tr);
      if a then l:=rolechar[apc]
    end
  end
end;

{ These procedures are called to select then value of an attacked piece }

function FindCheapWin(yours: roletype; mvd: boolean): roletype;
var mine: roletype;
    found: boolean;
begin
  found:=false;
  mine:=yours;
  if mvd or (nmoved[red]<16) then
  begin
    while not found and (mine>general) do
    begin
      dec(mine);
      if bag[mine,red]>0 then found:=true
    end;
    if not found then
    begin
      if bag[yours,red]>0 then
      begin
        found:=true;
        mine:=yours
      end
    end
  end;
  if not found then
  begin
    if not(yours=minor) and (bag[bomb,red]>0) and not(mvd) then
    begin
      found:=true;
      mine:=bomb
    end
  end;
  if not found then
  begin
    if mvd or (nmoved[red]<16) then
    begin
      mine:=spy;
      while not found and (mine>succ(yours)) do
      begin
        dec(mine);
        if bag[mine,red]>0 then found:=true
      end;
      if not found then if bag[spy,red]>0 then
      begin
        found:=true;
        mine:=spy
      end
    end
  end;
  if not found then if bag[bomb,red]>0 then mine:=bomb else mine:=flag;
  FindCheapWin:=mine
end;

function GuessConservative(mvd: boolean): roletype;
var mine,start,last: roletype;
    nlist,i: integer;
    list: array[1..20] of roletype;
begin
  nlist:=0;
  if mvd then start:=general else start:=bomb;
  if mvd or (nmoved[red]<16) then last:=spy else last:=bomb;
  for mine:=start to last do
  begin
    for i:=1 to bag[mine,red] do
    begin
      inc(nlist);
      list[nlist]:=mine
    end
  end;
  if nlist=0 then GuessConservative:=flag else
  begin
    i:=1+random(nlist);
    GuessConservative:=list[i]
  end
end;

procedure SelectPiece(var s: string);
var pc,ypc: piecetype;
    nr: roletype;
begin
  { TODO }
  pc:=piece[board[tocol,torow].pieceno,red];
  if pc.known then s:=rolechar[pc.value] else
  begin
    ypc:=piece[board[fromcol,fromrow].pieceno,not red];
    if ypc.known then nr:=FindCheapWin(ypc.value,pc.moved)
                 else nr:=GuessConservative(pc.moved);
    SetValue(board[tocol,torow].pieceno,red,nr);
    s:=rolechar[nr]
  end;
  defense:=chrole[s[1]]
end;

{ This procedure is called when the game is started }

procedure PerformInit;
begin
  readInputLine;
  if line = 'Start' then
  begin
    red := true;
    stat := tomove
  end else
  begin
    red := false;
    ProcesMove(line)
  end
end;

{ This procedure is called when it is time to make a move }

procedure PerformTomove;
var attack: boolean;
    letter: char;
begin
  SelectMove(line,attack,letter);
  writeOutputLine;
  if attack then
  begin
    line := letter;
    writeOutputLine;
    stat := attacking
  end else
  begin
    MovePiece(moving,red);
    {$IFDEF debug}
    ShowBoard;
    {$ENDIF}
    stat := waiting
  end;
  inc(nMoves)
end;


{ This procedure is called when an attack is performed }

procedure PerformAttacking;
begin
  readInputLine;
  if (line = 'X') or (line = 'V') then stat := ready else
  begin
    defense:=chrole[line[1]];
    if not(piece[board[tocol,torow].pieceno,not red].known)
      then SetValue(board[tocol,torow].pieceno,not red,defense);
    if attackpiece=defense then
    begin
      RemovePiece(board[fromcol,fromrow].pieceno,red);
      RemovePiece(board[tocol,torow].pieceno,not red)
    end else if wintable[attackpiece,defense] then
    begin
      RemovePiece(board[tocol,torow].pieceno,not red);
      MovePiece(board[fromcol,fromrow].pieceno,red)
    end else RemovePiece(board[fromcol,fromrow].pieceno,red);
    {$IFDEF debug}
    ShowBoard;
    {$ENDIF}
    stat := waiting
  end
end;

{ This procedure is called when the opponent has to move }

procedure PerformWaiting;
begin
  readInputLine;
  if line = 'X' then stat := ready else ProcesMove(line)
end;

{ This procedure is called when the opponent attacked }

procedure PerformAttacked;
begin
  SelectPiece(line);
  writeOutputLine;
  stat := defending
end;

{ This procedure is called when the opponent has to reveil his piece }

Procedure PerformDefending;
begin
  readInputLine;
  if line = 'X' then stat := ready else
  begin
    attackpiece:=chrole[line[1]];
    if not(piece[board[fromcol,fromrow].pieceno,not red].known)
      then SetValue(board[fromcol,fromrow].pieceno,not red,attackpiece);
    if attackpiece=defense then
    begin
      RemovePiece(board[fromcol,fromrow].pieceno,not red);
      RemovePiece(board[tocol,torow].pieceno,red)
    end else if wintable[attackpiece,defense] then
    begin
      RemovePiece(board[tocol,torow].pieceno,red);
      MovePiece(board[fromcol,fromrow].pieceno,not red)
    end else RemovePiece(board[fromcol,fromrow].pieceno,not red);
    {$IFDEF debug}
    ShowBoard;
    {$ENDIF}
    if defense=flag then stat:=ready else stat:=tomove
  end
end;

{ Main program }

begin
  InitGame;
  while stat<>ready do
  begin
    case stat of
    init:      PerformInit;
    tomove:    PerformTomove;
    attacking: PerformAttacking;
    waiting:   PerformWaiting;
    attacked:  PerformAttacked;
    defending: PerformDefending;
    end
  end
end.

