/* Copyright (C) 2005 Jaap Taal and Marcel Vlastuin.

This file is part of the Caia project. This project can be
downloaded from the website www.codecup.nl. You can email to
marcel@vlastuin.net or write to Marcel Vlastuin, Perenstraat 40,
2564 SE Den Haag, The Netherlands.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; see the file COPYING.  If not, write to
the Free Software Foundation, 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */

#include <stdio.h>
#include <string.h>
#include <stdarg.h>

#define LOCK(x) printf("I lock\n"); fflush(stdout); do scanf("%s", (x)); while (strcmp((x), "lock_ok"))
#define UNLOCK printf("I unlock\n"); fflush(stdout)

// prflush() is a combination of a printf() followed by a fflush(stdout).
// The flushing is necessary to put the caiaio immediately on a job.

int prflush(char *fmt, ...)
{
  int r;
  va_list ap;
  va_start(ap, fmt);
  r = vprintf(fmt, ap);
  va_end(ap);
  fflush(stdout);
  return r;
}

// fprflush() is a combination of a fprintf(stream, ...) and a fflush(stream).
// In this program only fprintf(stderr, ...) and fflush(stderr) is used.

int fprflush(FILE *stream, char *fmt, ...)
{
  int r;
  va_list ap;
  va_start(ap, fmt);
  r = vfprintf(stream, fmt, ap);
  va_end(ap);
  fflush(stream);
  return r;
}

int main (int argc, char *argv[])
{
  FILE *instr = NULL;
  int i, ngames;
  int answer1, answer2, answer3, answer4, answer5, answer6, answer7;
  char log1[80], log2[80], buf3[80], buf4[80], buf5[80], dummy[80];
  char player1[80], player2[80];
  
// Use the next line if your computer CPU speed is 266 MHz:
  
//prflush("I cpu_speed 2800 266\n");

// Use the next line if you let de caiaio make a guess of the CPU speed:

  prflush("I cpu_speed 2800\n");

// It is possible to leave both lines out, in that case the caiaio asumes that
// your computer CPU speed is the same as that of the CodeCup computer.
  
  if (argc >= 2) instr = fopen(argv[1], "r");
  else instr = fopen("manager.txt", "r");

// The file manager.txt, or another one, must exist! Read the documentation about this.
  
  if (instr == NULL) 
  {
    fprflush(stderr, "Non-existing filename\n");
    prflush("I stop_caiaio\n");
    return 1;
  }

// Read the number of games to be played:
  
  fscanf(instr, "%d", &ngames);
  for (i=0; i<ngames; i++)
  {

// Read the names of both players and log files:

    fscanf(instr, "%s", player1);
    fscanf(instr, "%s", log1);
    fscanf(instr, "%s", player2);
    fscanf(instr, "%s", log2);
    
    fprflush(stderr, "M: GAME %d = %s <> %s\n", i+1, player1, player2);
    
    LOCK(dummy);
    
// Inform the caiaio that here are 2 players:    
    
    prflush("I number_players 2\n");

// Inform the caiaio who player 1 is and where its stderr can be printed to
// (if the player does so)
// The playing time for player 1 is 30000 milliseconds:
    
    prflush("I player 1 %s 30000 ../playerlogs/%s\n", player1, log1);

// After that, start the player and wait 20 milliseconds for the firsterror:
// (for more details: see the Caia documentation)

    prflush("I start 1 20\n");

// There are two possibilities:
// 1. "no_firsterror" is returned by the caiaio if the player did not printed anything
//    to its stderr since 20 milliseconds after being started.
// 2. "firsterror string1 string2" is returned by the cacaio. In this case the player
//    must return two strings in order to identify himself.
//
// Use "I start 1\n" if no firsterror is expected or used!
// In that case the next 6 lines should be ommited as well:
    
    scanf("%s", buf3);
    if (!strcmp(buf3, "firsterror"))
    { 
      scanf("%s", buf4);
      scanf("%s", buf5);
    }

// Repeat for player 2:
    
    prflush("I player 2 %s 30000 ../playerlogs/%s\n", player2, log2);
    prflush("I start 2 20\n");
    scanf("%s", buf3);
    if (!strcmp(buf3, "firsterror"))
    { 
      scanf("%s", buf4);
      scanf("%s", buf5);
    }
    
    UNLOCK;

// Put the referee on a job and provide him a unique log file name:
// You must be unlocked before giving this command to the caiaio!
    
    prflush("I referee referee ../refereelogs/referee.%s-%s.%d.log\n", player1, player2, i+1);
    
// The referee sends back: "report gamepoints1 gamepoints2 numberpieces1 numberpieces2 illegal1 illegal2 resultnumber resultstring\n":
// The referee must be written this way to do this!
    
    scanf("%s", dummy);    // string report
    scanf("%d", &answer1); // int gamepoints1
    scanf("%d", &answer2); // int gamepoints2
    scanf("%d", &answer3); // int numberpieces1
    scanf("%d", &answer4); // int numberpieces2
    scanf("%d", &answer5); // int illegal points 1
    scanf("%d", &answer6); // int illegal points 2
    scanf("%d", &answer7); // int resultnumber
    scanf("%s", buf3);     // string resultstring
    fprflush(stderr, "M: RESULT = %d %d %d %d %d %d %d %s\n", answer1, answer2, answer3, answer4, answer5, answer6, answer7, buf3);

// Make sure all 3 processes are killed:
    
    prflush("I kill_referee\n");
    prflush("I kill 1\n");
    prflush("I kill 2\n");
  }

// Tell the caiaio he stops himself:
  
  prflush("I stop_caiaio\n");
  return 0;
}

