/* 
Copyright (C) 2007 Thijs Marinussen
Copyright (C) 2005 Jaap Taal and Marcel Vlastuin.

This file is part of the Caia project. This project can be
downloaded from the website www.codecup.nl. You can email to
marcel@vlastuin.net or write to Marcel Vlastuin, Perenstraat 40,
2564 SE Den Haag, The Netherlands.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; see the file COPYING.  If not, write to
the Free Software Foundation, 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */

/* Use this code (older version; less accurate) if you have compiler or linker problems:

#include <stdio.h>
#include <sys/time.h>

int cpuspeed(void)
{
  long dif, count;
  volatile double dummy=1.0;
  struct timeval start, stop;
  gettimeofday(&start, NULL);
  for (count = 0; count < 50000000; ++count) dummy/=2;
  gettimeofday(&stop, NULL);
  dif = 1000000 * (stop.tv_sec - start.tv_sec) + stop.tv_usec - start.tv_usec;
  return int(266.0*5210000.0/float(dif))+(int)dummy;
}

*/

#include <stdlib.h>
#include <stdio.h>
#include <sys/time.h>

/*
getTSC saves the current value of the time stamp counter in *counter
*/

#ifdef __APPLE__

inline void getTSC(unsigned long long *counter){
	__asm__("pushl %%edx\n\t"
		"rdtsc \n\t"
		"movl %%eax, (%%edi)\n\t"
		"movl %%edx, 4(%%edi)\n\t"
		"popl %%edx\n\t"
		: : "D" (counter) : "eax", "edx");
}

#else // used for __linux__ ; __CYGWIN__ ; _WIN32

inline void getTSC(unsigned long long *counter){
	__asm__(".intel_syntax noprefix\n\t"
		"push edx\n\t"
		"rdtsc\n\t"
		"mov dword ptr [edi], eax\n\t"
		"mov dword ptr [edi+4], edx\n\t"
		"pop edx\n\t"
		".att_syntax\n\t" : : "D" (counter) : "eax", "edx");
}

#endif

int cpuspeed(void)
{
  unsigned long long start,stop,clocks;
  timeval ts;
  ts.tv_sec = 0;
  ts.tv_usec = 100000; //Sleep 100.000 usec = 0.1 sec
  getTSC(&start);
  select(0,NULL,NULL,NULL,&ts);
  getTSC(&stop);
  clocks = stop-start; //Clocks now contains the number of clockticks in 0.1 second
  //The number of clockticks divided by 100.000 is the speed of the processor in Mhz
  //fprintf(stderr,"clocks=%llu\n",clocks);fflush(stderr);
  return clocks / 100000; 
}



